@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyStorageRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableImmediateAccess Snapshot speed available.
 */
public data class EnterpriseSnapshotPolicyStorageRuleArgs(
    public val enableImmediateAccess: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyStorageRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyStorageRuleArgs =
        com.pulumi.alicloud.ebs.inputs.EnterpriseSnapshotPolicyStorageRuleArgs.builder()
            .enableImmediateAccess(enableImmediateAccess?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnterpriseSnapshotPolicyStorageRuleArgs].
 */
@PulumiTagMarker
public class EnterpriseSnapshotPolicyStorageRuleArgsBuilder internal constructor() {
    private var enableImmediateAccess: Output<Boolean>? = null

    /**
     * @param value Snapshot speed available.
     */
    @JvmName("pwwrbicaotuaoerj")
    public suspend fun enableImmediateAccess(`value`: Output<Boolean>) {
        this.enableImmediateAccess = value
    }

    /**
     * @param value Snapshot speed available.
     */
    @JvmName("afrueawebnltnuij")
    public suspend fun enableImmediateAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableImmediateAccess = mapped
    }

    internal fun build(): EnterpriseSnapshotPolicyStorageRuleArgs =
        EnterpriseSnapshotPolicyStorageRuleArgs(
            enableImmediateAccess = enableImmediateAccess,
        )
}
