@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.GetDiskReplicaGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDiskReplicaGroups.
 * @property ids A list of Disk Replica Group IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetDiskReplicaGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.GetDiskReplicaGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.GetDiskReplicaGroupsPlainArgs =
        com.pulumi.alicloud.ebs.inputs.GetDiskReplicaGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiskReplicaGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetDiskReplicaGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Disk Replica Group IDs.
     */
    @JvmName("eofeolvqqtqfhfsw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Disk Replica Group IDs.
     */
    @JvmName("heipsttqvmiqnwko")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("flwsunnsrtrahkdl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetDiskReplicaGroupsPlainArgs = GetDiskReplicaGroupsPlainArgs(
        ids = ids,
        outputFile = outputFile,
    )
}
