@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.GetDiskReplicaPairsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDiskReplicaPairs.
 * @property ids A list of Disk Replica Pair IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property replicaGroupId Consistent Replication Group ID, you can specify a consistent replication group ID to query the replication pairs within the group.
 * @property site Get data for replication pairs where this Region is the production site or the disaster recovery site.
 */
public data class GetDiskReplicaPairsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val replicaGroupId: String? = null,
    public val site: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.GetDiskReplicaPairsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.GetDiskReplicaPairsPlainArgs =
        com.pulumi.alicloud.ebs.inputs.GetDiskReplicaPairsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .replicaGroupId(replicaGroupId?.let({ args0 -> args0 }))
            .site(site?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiskReplicaPairsPlainArgs].
 */
@PulumiTagMarker
public class GetDiskReplicaPairsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var replicaGroupId: String? = null

    private var site: String? = null

    /**
     * @param value A list of Disk Replica Pair IDs.
     */
    @JvmName("sfvohaweywliipos")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Disk Replica Pair IDs.
     */
    @JvmName("lbphuiapbwkgrlcj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tbqnffhwllrpevkk")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Consistent Replication Group ID, you can specify a consistent replication group ID to query the replication pairs within the group.
     */
    @JvmName("bogcvcsmwelociur")
    public suspend fun replicaGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.replicaGroupId = mapped
    }

    /**
     * @param value Get data for replication pairs where this Region is the production site or the disaster recovery site.
     */
    @JvmName("nvbdradqjbcclngj")
    public suspend fun site(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.site = mapped
    }

    internal fun build(): GetDiskReplicaPairsPlainArgs = GetDiskReplicaPairsPlainArgs(
        ids = ids,
        outputFile = outputFile,
        replicaGroupId = replicaGroupId,
        site = site,
    )
}
