@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.GetRegionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegions.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property regionId A list of Disk Replica Group IDs.
 */
public data class GetRegionsPlainArgs(
    public val outputFile: String? = null,
    public val regionId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.GetRegionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.GetRegionsPlainArgs =
        com.pulumi.alicloud.ebs.inputs.GetRegionsPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .regionId(regionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegionsPlainArgs].
 */
@PulumiTagMarker
public class GetRegionsPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    private var regionId: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tkgyavpnpppylprq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value A list of Disk Replica Group IDs.
     */
    @JvmName("gvigkxdjsfxgitog")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regionId = mapped
    }

    internal fun build(): GetRegionsPlainArgs = GetRegionsPlainArgs(
        outputFile = outputFile,
        regionId = regionId,
    )
}
