@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.inputs

import com.pulumi.alicloud.ebs.inputs.SolutionInstanceParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterKey Create parameter Key.
 * @property parameterValue Create parameter Value.
 */
public data class SolutionInstanceParameterArgs(
    public val parameterKey: Output<String>,
    public val parameterValue: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ebs.inputs.SolutionInstanceParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.ebs.inputs.SolutionInstanceParameterArgs =
        com.pulumi.alicloud.ebs.inputs.SolutionInstanceParameterArgs.builder()
            .parameterKey(parameterKey.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SolutionInstanceParameterArgs].
 */
@PulumiTagMarker
public class SolutionInstanceParameterArgsBuilder internal constructor() {
    private var parameterKey: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value Create parameter Key.
     */
    @JvmName("itxjihbpfjiapmvb")
    public suspend fun parameterKey(`value`: Output<String>) {
        this.parameterKey = value
    }

    /**
     * @param value Create parameter Value.
     */
    @JvmName("hlvbahdxfkmnwunh")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value Create parameter Key.
     */
    @JvmName("wwpqijbhigsaovki")
    public suspend fun parameterKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterKey = mapped
    }

    /**
     * @param value Create parameter Value.
     */
    @JvmName("pntyadcbeddfirnk")
    public suspend fun parameterValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): SolutionInstanceParameterArgs = SolutionInstanceParameterArgs(
        parameterKey = parameterKey ?: throw PulumiNullFieldException("parameterKey"),
        parameterValue = parameterValue ?: throw PulumiNullFieldException("parameterValue"),
    )
}
