@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enabled Whether special reservations are enabled. Value range:
 * - true
 * - false.
 * @property rules List of special retention rules. See `rules` below.
 */
public data class EnterpriseSnapshotPolicySpecialRetainRules(
    public val enabled: Boolean? = null,
    public val rules: List<EnterpriseSnapshotPolicySpecialRetainRulesRule>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.EnterpriseSnapshotPolicySpecialRetainRules): EnterpriseSnapshotPolicySpecialRetainRules = EnterpriseSnapshotPolicySpecialRetainRules(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ebs.kotlin.outputs.EnterpriseSnapshotPolicySpecialRetainRulesRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
