@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property specialPeriodUnit The cycle unit of the special reserved snapshot. If the value is set to WEEKS, the first snapshot of each week is reserved. The retention time is determined by TimeUnit and TimeInterval. The value range is:
 * - WEEKS
 * - MONTHS
 * - YEARS.
 * @property timeInterval
 * @property timeUnit
 */
public data class EnterpriseSnapshotPolicySpecialRetainRulesRule(
    public val specialPeriodUnit: String? = null,
    public val timeInterval: Int? = null,
    public val timeUnit: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.EnterpriseSnapshotPolicySpecialRetainRulesRule): EnterpriseSnapshotPolicySpecialRetainRulesRule =
            EnterpriseSnapshotPolicySpecialRetainRulesRule(
                specialPeriodUnit = javaType.specialPeriodUnit().map({ args0 -> args0 }).orElse(null),
                timeInterval = javaType.timeInterval().map({ args0 -> args0 }).orElse(null),
                timeUnit = javaType.timeUnit().map({ args0 -> args0 }).orElse(null),
            )
    }
}
