@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availableCapacity The available capacity of the dedicated block storage cluster. Unit: GiB.
 * @property category The type of cloud disk that can be created by a dedicated block storage cluster.
 * @property createTime The creation time of the resource
 * @property dedicatedBlockStorageClusterId The first ID of the resource
 * @property dedicatedBlockStorageClusterName The name of the resource
 * @property deliveryCapacity Capacity to be delivered in GB.
 * @property description The description of the dedicated block storage cluster.
 * @property expiredTime The expiration time of the dedicated block storage cluster, in the Unix timestamp format, in seconds.
 * @property id
 * @property performanceLevel Cloud disk performance level, possible values:-PL0.-PL1.-PL2.-PL3.> Only valid in SupportedCategory = cloud_essd.
 * @property resourceGroupId The ID of the resource group
 * @property status The status of the resource
 * @property supportedCategory This parameter is not supported.
 * @property totalCapacity The total capacity of the dedicated block storage cluster. Unit: GiB.
 * @property type The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
 * @property usedCapacity The used (created disk) capacity of the current cluster, in GB
 * @property zoneId The zone ID  of the resource
 */
public data class GetDedicatedBlockStorageClustersCluster(
    public val availableCapacity: String,
    public val category: String,
    public val createTime: String,
    public val dedicatedBlockStorageClusterId: String,
    public val dedicatedBlockStorageClusterName: String,
    public val deliveryCapacity: String,
    public val description: String,
    public val expiredTime: String,
    public val id: String,
    public val performanceLevel: String,
    public val resourceGroupId: String,
    public val status: String,
    public val supportedCategory: String,
    public val totalCapacity: String,
    public val type: String,
    public val usedCapacity: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.GetDedicatedBlockStorageClustersCluster): GetDedicatedBlockStorageClustersCluster = GetDedicatedBlockStorageClustersCluster(
            availableCapacity = javaType.availableCapacity(),
            category = javaType.category(),
            createTime = javaType.createTime(),
            dedicatedBlockStorageClusterId = javaType.dedicatedBlockStorageClusterId(),
            dedicatedBlockStorageClusterName = javaType.dedicatedBlockStorageClusterName(),
            deliveryCapacity = javaType.deliveryCapacity(),
            description = javaType.description(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            performanceLevel = javaType.performanceLevel(),
            resourceGroupId = javaType.resourceGroupId(),
            status = javaType.status(),
            supportedCategory = javaType.supportedCategory(),
            totalCapacity = javaType.totalCapacity(),
            type = javaType.type(),
            usedCapacity = javaType.usedCapacity(),
            zoneId = javaType.zoneId(),
        )
    }
}
