@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDedicatedBlockStorageClusters.
 * @property clusters A list of Dedicated Block Storage Cluster Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Dedicated Block Storage Cluster IDs.
 * @property nameRegex
 * @property names A list of name of Dedicated Block Storage Clusters.
 * @property outputFile
 */
public data class GetDedicatedBlockStorageClustersResult(
    public val clusters: List<GetDedicatedBlockStorageClustersCluster>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.GetDedicatedBlockStorageClustersResult): GetDedicatedBlockStorageClustersResult = GetDedicatedBlockStorageClustersResult(
            clusters = javaType.clusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ebs.kotlin.outputs.GetDedicatedBlockStorageClustersCluster.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
