@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the consistent replication group.
 * @property destinationRegionId The ID of the region to which the disaster recovery site belongs.
 * @property destinationZoneId The ID of the zone to which the disaster recovery site belongs.
 * @property groupName Consistent replication group name.
 * @property id The ID of the Disk Replica Group.
 * @property lastRecoverPoint
 * @property primaryRegion The initial source region of the replication group.
 * @property primaryZone The initial source available area of the replication group.
 * @property replicaGroupId The ID of the consistent replication group.
 * @property rpo The recovery point objective (RPO) of the replication pair-consistent group.
 * @property site Site information sources for replication pairs and consistent replication groups.
 * @property sourceRegionId The ID of the region to which the production site belongs.
 * @property sourceZoneId The ID of the zone to which the production site belongs.
 * @property standbyRegion The initial destination region of the replication group.
 * @property standbyZone The initial destination zone of the replication group.
 * @property status The status of the consistent replication group. Possible values:
 */
public data class GetDiskReplicaGroupsGroup(
    public val description: String,
    public val destinationRegionId: String,
    public val destinationZoneId: String,
    public val groupName: String,
    public val id: String,
    public val lastRecoverPoint: String,
    public val primaryRegion: String,
    public val primaryZone: String,
    public val replicaGroupId: String,
    public val rpo: Int,
    public val site: String,
    public val sourceRegionId: String,
    public val sourceZoneId: String,
    public val standbyRegion: String,
    public val standbyZone: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.GetDiskReplicaGroupsGroup): GetDiskReplicaGroupsGroup = GetDiskReplicaGroupsGroup(
            description = javaType.description(),
            destinationRegionId = javaType.destinationRegionId(),
            destinationZoneId = javaType.destinationZoneId(),
            groupName = javaType.groupName(),
            id = javaType.id(),
            lastRecoverPoint = javaType.lastRecoverPoint(),
            primaryRegion = javaType.primaryRegion(),
            primaryZone = javaType.primaryZone(),
            replicaGroupId = javaType.replicaGroupId(),
            rpo = javaType.rpo(),
            site = javaType.site(),
            sourceRegionId = javaType.sourceRegionId(),
            sourceZoneId = javaType.sourceZoneId(),
            standbyRegion = javaType.standbyRegion(),
            standbyZone = javaType.standbyZone(),
            status = javaType.status(),
        )
    }
}
