@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDiskReplicaGroups.
 * @property groups
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 */
public data class GetDiskReplicaGroupsResult(
    public val groups: List<GetDiskReplicaGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.GetDiskReplicaGroupsResult): GetDiskReplicaGroupsResult = GetDiskReplicaGroupsResult(
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ebs.kotlin.outputs.GetDiskReplicaGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
