@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:-10240 Kbps: equal to 10 Mbps.-20480 Kbps: equal to 20 Mbps.-51200 Kbps: equal to 50 Mbps.-102400 Kbps: equal to 100 Mbps.Default value: 10240.This parameter cannot be specified when the ChargeType value is POSTPAY. The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
 * @property description The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
 * @property destinationDiskId The ID of the standby disk.
 * @property destinationRegionId The ID of the region to which the disaster recovery site belongs.
 * @property destinationZoneId The ID of the zone to which the disaster recovery site belongs.
 * @property diskId The ID of the primary disk.
 * @property id
 * @property pairName The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
 * @property paymentType The payment type of the resource.
 * @property replicaPairId The first ID of the resource
 * @property resourceGroupId The ID of the resource group
 * @property rpo The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
 * @property sourceZoneId The ID of the zone to which the production site belongs.
 * @property status The status of the resource.
 */
public data class GetDiskReplicaPairsPair(
    public val bandwidth: String,
    public val description: String,
    public val destinationDiskId: String,
    public val destinationRegionId: String,
    public val destinationZoneId: String,
    public val diskId: String,
    public val id: String,
    public val pairName: String,
    public val paymentType: String,
    public val replicaPairId: String,
    public val resourceGroupId: String,
    public val rpo: String,
    public val sourceZoneId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.GetDiskReplicaPairsPair): GetDiskReplicaPairsPair = GetDiskReplicaPairsPair(
            bandwidth = javaType.bandwidth(),
            description = javaType.description(),
            destinationDiskId = javaType.destinationDiskId(),
            destinationRegionId = javaType.destinationRegionId(),
            destinationZoneId = javaType.destinationZoneId(),
            diskId = javaType.diskId(),
            id = javaType.id(),
            pairName = javaType.pairName(),
            paymentType = javaType.paymentType(),
            replicaPairId = javaType.replicaPairId(),
            resourceGroupId = javaType.resourceGroupId(),
            rpo = javaType.rpo(),
            sourceZoneId = javaType.sourceZoneId(),
            status = javaType.status(),
        )
    }
}
