@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDiskReplicaPairs.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Disk Replica Pair IDs.
 * @property outputFile
 * @property pairs A list of Disk Replica Pair Entries. Each element contains the following attributes:
 * @property replicaGroupId
 * @property site
 */
public data class GetDiskReplicaPairsResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val pairs: List<GetDiskReplicaPairsPair>,
    public val replicaGroupId: String? = null,
    public val site: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.GetDiskReplicaPairsResult): GetDiskReplicaPairsResult = GetDiskReplicaPairsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pairs = javaType.pairs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ebs.kotlin.outputs.GetDiskReplicaPairsPair.Companion.toKotlin(args0)
                })
            }),
            replicaGroupId = javaType.replicaGroupId().map({ args0 -> args0 }).orElse(null),
            site = javaType.site().map({ args0 -> args0 }).orElse(null),
        )
    }
}
