@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property regionId The ID of the region.
 * @property zones A list of Ebs Zones.
 */
public data class GetRegionsRegion(
    public val regionId: String,
    public val zones: List<GetRegionsRegionZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.GetRegionsRegion): GetRegionsRegion = GetRegionsRegion(
            regionId = javaType.regionId(),
            zones = javaType.zones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ebs.kotlin.outputs.GetRegionsRegionZone.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
