@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRegions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property regionId
 * @property regions
 */
public data class GetRegionsResult(
    public val id: String,
    public val outputFile: String? = null,
    public val regionId: String? = null,
    public val regions: List<GetRegionsRegion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ebs.outputs.GetRegionsResult): GetRegionsResult = GetRegionsResult(
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            regionId = javaType.regionId().map({ args0 -> args0 }).orElse(null),
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ebs.kotlin.outputs.GetRegionsRegion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
