@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin

import com.pulumi.alicloud.eci.ContainerGroupArgs.builder
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupAcrRegistryInfoArgs
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupAcrRegistryInfoArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupContainerArgs
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupContainerArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupDnsConfigArgs
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupDnsConfigArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupHostAliasArgs
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupHostAliasArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupImageRegistryCredentialArgs
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupImageRegistryCredentialArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupInitContainerArgs
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupInitContainerArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupSecurityContextArgs
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupSecurityContextArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupVolumeArgs
import com.pulumi.alicloud.eci.kotlin.inputs.ContainerGroupVolumeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides ECI Container Group resource.
 * For information about ECI Container Group and how to use it, see [What is Container Group](https://www.alibabacloud.com/help/en/elastic-container-instance/latest/api-eci-2018-08-08-createcontainergroup).
 * > **NOTE:** Available since v1.111.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.eci.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.1.0.0/16",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?&#46;zoneIds?&#46;[0]),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultContainerGroup = new alicloud.eci.ContainerGroup("default", {
 *     containerGroupName: name,
 *     cpu: 8,
 *     memory: 16,
 *     restartPolicy: "OnFailure",
 *     securityGroupId: defaultSecurityGroup.id,
 *     vswitchId: defaultSwitch.id,
 *     autoCreateEip: true,
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 *     containers: [{
 *         image: "registry.cn-beijing.aliyuncs.com/eci_open/nginx:alpine",
 *         name: "nginx",
 *         workingDir: "/tmp/nginx",
 *         imagePullPolicy: "IfNotPresent",
 *         commands: [
 *             "/bin/sh",
 *             "-c",
 *             "sleep 9999",
 *         ],
 *         volumeMounts: [{
 *             mountPath: "/tmp/example",
 *             readOnly: false,
 *             name: "empty1",
 *         }],
 *         ports: [{
 *             port: 80,
 *             protocol: "TCP",
 *         }],
 *         environmentVars: [{
 *             key: "name",
 *             value: "nginx",
 *         }],
 *         livenessProbes: [{
 *             periodSeconds: 5,
 *             initialDelaySeconds: 5,
 *             successThreshold: 1,
 *             failureThreshold: 3,
 *             timeoutSeconds: 1,
 *             execs: [{
 *                 commands: ["cat /tmp/healthy"],
 *             }],
 *         }],
 *         readinessProbes: [{
 *             periodSeconds: 5,
 *             initialDelaySeconds: 5,
 *             successThreshold: 1,
 *             failureThreshold: 3,
 *             timeoutSeconds: 1,
 *             execs: [{
 *                 commands: ["cat /tmp/healthy"],
 *             }],
 *         }],
 *     }],
 *     initContainers: [{
 *         name: "init-busybox",
 *         image: "registry.cn-beijing.aliyuncs.com/eci_open/busybox:1.30",
 *         imagePullPolicy: "IfNotPresent",
 *         commands: ["echo"],
 *         args: ["hello initcontainer"],
 *     }],
 *     volumes: [
 *         {
 *             name: "empty1",
 *             type: "EmptyDirVolume",
 *         },
 *         {
 *             name: "empty2",
 *             type: "EmptyDirVolume",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.eci.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.0.0.0/8")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.1.0.0/16",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0]&#46;zone_ids[0])
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_container_group = alicloud.eci.ContainerGroup("default",
 *     container_group_name=name,
 *     cpu=8,
 *     memory=16,
 *     restart_policy="OnFailure",
 *     security_group_id=default_security_group.id,
 *     vswitch_id=default_switch.id,
 *     auto_create_eip=True,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     },
 *     containers=[{
 *         "image": "registry.cn-beijing.aliyuncs.com/eci_open/nginx:alpine",
 *         "name": "nginx",
 *         "working_dir": "/tmp/nginx",
 *         "image_pull_policy": "IfNotPresent",
 *         "commands": [
 *             "/bin/sh",
 *             "-c",
 *             "sleep 9999",
 *         ],
 *         "volume_mounts": [{
 *             "mount_path": "/tmp/example",
 *             "read_only": False,
 *             "name": "empty1",
 *         }],
 *         "ports": [{
 *             "port": 80,
 *             "protocol": "TCP",
 *         }],
 *         "environment_vars": [{
 *             "key": "name",
 *             "value": "nginx",
 *         }],
 *         "liveness_probes": [{
 *             "period_seconds": 5,
 *             "initial_delay_seconds": 5,
 *             "success_threshold": 1,
 *             "failure_threshold": 3,
 *             "timeout_seconds": 1,
 *             "execs": [{
 *                 "commands": ["cat /tmp/healthy"],
 *             }],
 *         }],
 *         "readiness_probes": [{
 *             "period_seconds": 5,
 *             "initial_delay_seconds": 5,
 *             "success_threshold": 1,
 *             "failure_threshold": 3,
 *             "timeout_seconds": 1,
 *             "execs": [{
 *                 "commands": ["cat /tmp/healthy"],
 *             }],
 *         }],
 *     }],
 *     init_containers=[{
 *         "name": "init-busybox",
 *         "image": "registry.cn-beijing.aliyuncs.com/eci_open/busybox:1.30",
 *         "image_pull_policy": "IfNotPresent",
 *         "commands": ["echo"],
 *         "args": ["hello initcontainer"],
 *     }],
 *     volumes=[
 *         {
 *             "name": "empty1",
 *             "type": "EmptyDirVolume",
 *         },
 *         {
 *             "name": "empty2",
 *             "type": "EmptyDirVolume",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Eci.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.1.0.0/16",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?&#46;ZoneIds[0])),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultContainerGroup = new AliCloud.Eci.ContainerGroup("default", new()
 *     {
 *         ContainerGroupName = name,
 *         Cpu = 8,
 *         Memory = 16,
 *         RestartPolicy = "OnFailure",
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         VswitchId = defaultSwitch.Id,
 *         AutoCreateEip = true,
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *         Containers = new[]
 *         {
 *             new AliCloud.Eci.Inputs.ContainerGroupContainerArgs
 *             {
 *                 Image = "registry.cn-beijing.aliyuncs.com/eci_open/nginx:alpine",
 *                 Name = "nginx",
 *                 WorkingDir = "/tmp/nginx",
 *                 ImagePullPolicy = "IfNotPresent",
 *                 Commands = new[]
 *                 {
 *                     "/bin/sh",
 *                     "-c",
 *                     "sleep 9999",
 *                 },
 *                 VolumeMounts = new[]
 *                 {
 *                     new AliCloud.Eci.Inputs.ContainerGroupContainerVolumeMountArgs
 *                     {
 *                         MountPath = "/tmp/example",
 *                         ReadOnly = false,
 *                         Name = "empty1",
 *                     },
 *                 },
 *                 Ports = new[]
 *                 {
 *                     new AliCloud.Eci.Inputs.ContainerGroupContainerPortArgs
 *                     {
 *                         Port = 80,
 *                         Protocol = "TCP",
 *                     },
 *                 },
 *                 EnvironmentVars = new[]
 *                 {
 *                     new AliCloud.Eci.Inputs.ContainerGroupContainerEnvironmentVarArgs
 *                     {
 *                         Key = "name",
 *                         Value = "nginx",
 *                     },
 *                 },
 *                 LivenessProbes = new[]
 *                 {
 *                     new AliCloud.Eci.Inputs.ContainerGroupContainerLivenessProbeArgs
 *                     {
 *                         PeriodSeconds = 5,
 *                         InitialDelaySeconds = 5,
 *                         SuccessThreshold = 1,
 *                         FailureThreshold = 3,
 *                         TimeoutSeconds = 1,
 *                         Execs = new[]
 *                         {
 *                             new AliCloud.Eci.Inputs.ContainerGroupContainerLivenessProbeExecArgs
 *                             {
 *                                 Commands = new[]
 *                                 {
 *                                     "cat /tmp/healthy",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *                 ReadinessProbes = new[]
 *                 {
 *                     new AliCloud.Eci.Inputs.ContainerGroupContainerReadinessProbeArgs
 *                     {
 *                         PeriodSeconds = 5,
 *                         InitialDelaySeconds = 5,
 *                         SuccessThreshold = 1,
 *                         FailureThreshold = 3,
 *                         TimeoutSeconds = 1,
 *                         Execs = new[]
 *                         {
 *                             new AliCloud.Eci.Inputs.ContainerGroupContainerReadinessProbeExecArgs
 *                             {
 *                                 Commands = new[]
 *                                 {
 *                                     "cat /tmp/healthy",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         InitContainers = new[]
 *         {
 *             new AliCloud.Eci.Inputs.ContainerGroupInitContainerArgs
 *             {
 *                 Name = "init-busybox",
 *                 Image = "registry.cn-beijing.aliyuncs.com/eci_open/busybox:1.30",
 *                 ImagePullPolicy = "IfNotPresent",
 *                 Commands = new[]
 *                 {
 *                     "echo",
 *                 },
 *                 Args = new[]
 *                 {
 *                     "hello initcontainer",
 *                 },
 *             },
 *         },
 *         Volumes = new[]
 *         {
 *             new AliCloud.Eci.Inputs.ContainerGroupVolumeArgs
 *             {
 *                 Name = "empty1",
 *                 Type = "EmptyDirVolume",
 *             },
 *             new AliCloud.Eci.Inputs.ContainerGroupVolumeArgs
 *             {
 *                 Name = "empty2",
 *                 Type = "EmptyDirVolume",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eci"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := eci.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.1.0.0/16"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0]&#46;ZoneIds[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eci.NewContainerGroup(ctx, "default", &eci.ContainerGroupArgs{
 * 			ContainerGroupName: pulumi.String(name),
 * 			Cpu:                pulumi.Float64(8),
 * 			Memory:             pulumi.Float64(16),
 * 			RestartPolicy:      pulumi.String("OnFailure"),
 * 			SecurityGroupId:    defaultSecurityGroup.ID(),
 * 			VswitchId:          defaultSwitch.ID(),
 * 			AutoCreateEip:      pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 			Containers: eci.ContainerGroupContainerArray{
 * 				&eci.ContainerGroupContainerArgs{
 * 					Image:           pulumi.String("registry.cn-beijing.aliyuncs.com/eci_open/nginx:alpine"),
 * 					Name:            pulumi.String("nginx"),
 * 					WorkingDir:      pulumi.String("/tmp/nginx"),
 * 					ImagePullPolicy: pulumi.String("IfNotPresent"),
 * 					Commands: pulumi.StringArray{
 * 						pulumi.String("/bin/sh"),
 * 						pulumi.String("-c"),
 * 						pulumi.String("sleep 9999"),
 * 					},
 * 					VolumeMounts: eci.ContainerGroupContainerVolumeMountArray{
 * 						&eci.ContainerGroupContainerVolumeMountArgs{
 * 							MountPath: pulumi.String("/tmp/example"),
 * 							ReadOnly:  pulumi.Bool(false),
 * 							Name:      pulumi.String("empty1"),
 * 						},
 * 					},
 * 					Ports: eci.ContainerGroupContainerPortArray{
 * 						&eci.ContainerGroupContainerPortArgs{
 * 							Port:     pulumi.Int(80),
 * 							Protocol: pulumi.String("TCP"),
 * 						},
 * 					},
 * 					EnvironmentVars: eci.ContainerGroupContainerEnvironmentVarArray{
 * 						&eci.ContainerGroupContainerEnvironmentVarArgs{
 * 							Key:   pulumi.String("name"),
 * 							Value: pulumi.String("nginx"),
 * 						},
 * 					},
 * 					LivenessProbes: eci.ContainerGroupContainerLivenessProbeArray{
 * 						&eci.ContainerGroupContainerLivenessProbeArgs{
 * 							PeriodSeconds:       pulumi.Int(5),
 * 							InitialDelaySeconds: pulumi.Int(5),
 * 							SuccessThreshold:    pulumi.Int(1),
 * 							FailureThreshold:    pulumi.Int(3),
 * 							TimeoutSeconds:      pulumi.Int(1),
 * 							Execs: eci.ContainerGroupContainerLivenessProbeExecArray{
 * 								&eci.ContainerGroupContainerLivenessProbeExecArgs{
 * 									Commands: pulumi.StringArray{
 * 										pulumi.String("cat /tmp/healthy"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 					ReadinessProbes: eci.ContainerGroupContainerReadinessProbeArray{
 * 						&eci.ContainerGroupContainerReadinessProbeArgs{
 * 							PeriodSeconds:       pulumi.Int(5),
 * 							InitialDelaySeconds: pulumi.Int(5),
 * 							SuccessThreshold:    pulumi.Int(1),
 * 							FailureThreshold:    pulumi.Int(3),
 * 							TimeoutSeconds:      pulumi.Int(1),
 * 							Execs: eci.ContainerGroupContainerReadinessProbeExecArray{
 * 								&eci.ContainerGroupContainerReadinessProbeExecArgs{
 * 									Commands: pulumi.StringArray{
 * 										pulumi.String("cat /tmp/healthy"),
 * 									},
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			InitContainers: eci.ContainerGroupInitContainerArray{
 * 				&eci.ContainerGroupInitContainerArgs{
 * 					Name:            pulumi.String("init-busybox"),
 * 					Image:           pulumi.String("registry.cn-beijing.aliyuncs.com/eci_open/busybox:1.30"),
 * 					ImagePullPolicy: pulumi.String("IfNotPresent"),
 * 					Commands: pulumi.StringArray{
 * 						pulumi.String("echo"),
 * 					},
 * 					Args: pulumi.StringArray{
 * 						pulumi.String("hello initcontainer"),
 * 					},
 * 				},
 * 			},
 * 			Volumes: eci.ContainerGroupVolumeArray{
 * 				&eci.ContainerGroupVolumeArgs{
 * 					Name: pulumi.String("empty1"),
 * 					Type: pulumi.String("EmptyDirVolume"),
 * 				},
 * 				&eci.ContainerGroupVolumeArgs{
 * 					Name: pulumi.String("empty2"),
 * 					Type: pulumi.String("EmptyDirVolume"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eci.EciFunctions;
 * import com.pulumi.alicloud.eci.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.eci.ContainerGroup;
 * import com.pulumi.alicloud.eci.ContainerGroupArgs;
 * import com.pulumi.alicloud.eci.inputs.ContainerGroupContainerArgs;
 * import com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerArgs;
 * import com.pulumi.alicloud.eci.inputs.ContainerGroupVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = EciFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.1.0.0/16")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0]&#46;zoneIds()[0])
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultContainerGroup = new ContainerGroup("defaultContainerGroup", ContainerGroupArgs.builder()
 *             .containerGroupName(name)
 *             .cpu(8)
 *             .memory(16)
 *             .restartPolicy("OnFailure")
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .autoCreateEip(true)
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .containers(ContainerGroupContainerArgs.builder()
 *                 .image("registry.cn-beijing.aliyuncs.com/eci_open/nginx:alpine")
 *                 .name("nginx")
 *                 .workingDir("/tmp/nginx")
 *                 .imagePullPolicy("IfNotPresent")
 *                 .commands(
 *                     "/bin/sh",
 *                     "-c",
 *                     "sleep 9999")
 *                 .volumeMounts(ContainerGroupContainerVolumeMountArgs.builder()
 *                     .mountPath("/tmp/example")
 *                     .readOnly(false)
 *                     .name("empty1")
 *                     .build())
 *                 .ports(ContainerGroupContainerPortArgs.builder()
 *                     .port(80)
 *                     .protocol("TCP")
 *                     .build())
 *                 .environmentVars(ContainerGroupContainerEnvironmentVarArgs.builder()
 *                     .key("name")
 *                     .value("nginx")
 *                     .build())
 *                 .livenessProbes(ContainerGroupContainerLivenessProbeArgs.builder()
 *                     .periodSeconds("5")
 *                     .initialDelaySeconds("5")
 *                     .successThreshold("1")
 *                     .failureThreshold("3")
 *                     .timeoutSeconds("1")
 *                     .execs(ContainerGroupContainerLivenessProbeExecArgs.builder()
 *                         .commands("cat /tmp/healthy")
 *                         .build())
 *                     .build())
 *                 .readinessProbes(ContainerGroupContainerReadinessProbeArgs.builder()
 *                     .periodSeconds("5")
 *                     .initialDelaySeconds("5")
 *                     .successThreshold("1")
 *                     .failureThreshold("3")
 *                     .timeoutSeconds("1")
 *                     .execs(ContainerGroupContainerReadinessProbeExecArgs.builder()
 *                         .commands("cat /tmp/healthy")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .initContainers(ContainerGroupInitContainerArgs.builder()
 *                 .name("init-busybox")
 *                 .image("registry.cn-beijing.aliyuncs.com/eci_open/busybox:1.30")
 *                 .imagePullPolicy("IfNotPresent")
 *                 .commands("echo")
 *                 .args("hello initcontainer")
 *                 .build())
 *             .volumes(
 *                 ContainerGroupVolumeArgs.builder()
 *                     .name("empty1")
 *                     .type("EmptyDirVolume")
 *                     .build(),
 *                 ContainerGroupVolumeArgs.builder()
 *                     .name("empty2")
 *                     .type("EmptyDirVolume")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.0.0.0/8
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.1.0.0/16
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0]&#46;zoneIds[0]}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultContainerGroup:
 *     type: alicloud:eci:ContainerGroup
 *     name: default
 *     properties:
 *       containerGroupName: ${name}
 *       cpu: 8
 *       memory: 16
 *       restartPolicy: OnFailure
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       vswitchId: ${defaultSwitch.id}
 *       autoCreateEip: true
 *       tags:
 *         Created: TF
 *         For: example
 *       containers:
 *         - image: registry.cn-beijing.aliyuncs.com/eci_open/nginx:alpine
 *           name: nginx
 *           workingDir: /tmp/nginx
 *           imagePullPolicy: IfNotPresent
 *           commands:
 *             - /bin/sh
 *             - -c
 *             - sleep 9999
 *           volumeMounts:
 *             - mountPath: /tmp/example
 *               readOnly: false
 *               name: empty1
 *           ports:
 *             - port: 80
 *               protocol: TCP
 *           environmentVars:
 *             - key: name
 *               value: nginx
 *           livenessProbes:
 *             - periodSeconds: '5'
 *               initialDelaySeconds: '5'
 *               successThreshold: '1'
 *               failureThreshold: '3'
 *               timeoutSeconds: '1'
 *               execs:
 *                 - commands:
 *                     - cat /tmp/healthy
 *           readinessProbes:
 *             - periodSeconds: '5'
 *               initialDelaySeconds: '5'
 *               successThreshold: '1'
 *               failureThreshold: '3'
 *               timeoutSeconds: '1'
 *               execs:
 *                 - commands:
 *                     - cat /tmp/healthy
 *       initContainers:
 *         - name: init-busybox
 *           image: registry.cn-beijing.aliyuncs.com/eci_open/busybox:1.30
 *           imagePullPolicy: IfNotPresent
 *           commands:
 *             - echo
 *           args:
 *             - hello initcontainer
 *       volumes:
 *         - name: empty1
 *           type: EmptyDirVolume
 *         - name: empty2
 *           type: EmptyDirVolume
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eci:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECI Container Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eci/containerGroup:ContainerGroup example <container_group_id>
 * ```
 * @property acrRegistryInfos The ACR enterprise edition example properties. See `acr_registry_info` below.
 * @property autoCreateEip Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
 * @property autoMatchImageCache Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
 * @property containerGroupName The name of the container group.
 * @property containers The list of containers. See `containers` below.
 * @property cpu The amount of CPU resources allocated to the container group.
 * @property dnsConfig The structure of dnsConfig. See `dns_config` below.
 * @property eipBandwidth The bandwidth of the EIP. Default value: `5`.
 * @property eipInstanceId The ID of the elastic IP address (EIP).
 * @property hostAliases HostAliases. See `host_aliases` below.
 * @property imageRegistryCredentials The image registry credential. See `image_registry_credential` below.
 * @property initContainers The list of initContainers. See `init_containers` below.
 * @property insecureRegistry The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
 * @property instanceType The type of the ECS instance.
 * @property memory The amount of memory resources allocated to the container group.
 * @property plainHttpRegistry The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
 * @property ramRoleName The RAM role that the container group assumes. ECI and ECS share the same RAM role.
 * @property resourceGroupId The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
 * @property restartPolicy The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
 * @property securityContext The security context of the container group. See `security_context` below.
 * @property securityGroupId The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
 * @property spotPriceLimit The maximum hourly price of the ECI spot instance.
 * @property spotStrategy Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property terminationGracePeriodSeconds The buffer time during which the program handles operations before the program stops. Unit: seconds.
 * @property volumes The list of volumes. See `volumes` below.
 * @property vswitchId The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
 * **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
 * @property zoneId The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
 */
public data class ContainerGroupArgs(
    public val acrRegistryInfos: Output<List<ContainerGroupAcrRegistryInfoArgs>>? = null,
    public val autoCreateEip: Output<Boolean>? = null,
    public val autoMatchImageCache: Output<Boolean>? = null,
    public val containerGroupName: Output<String>? = null,
    public val containers: Output<List<ContainerGroupContainerArgs>>? = null,
    public val cpu: Output<Double>? = null,
    public val dnsConfig: Output<ContainerGroupDnsConfigArgs>? = null,
    public val eipBandwidth: Output<Int>? = null,
    public val eipInstanceId: Output<String>? = null,
    public val hostAliases: Output<List<ContainerGroupHostAliasArgs>>? = null,
    public val imageRegistryCredentials: Output<List<ContainerGroupImageRegistryCredentialArgs>>? =
        null,
    public val initContainers: Output<List<ContainerGroupInitContainerArgs>>? = null,
    public val insecureRegistry: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val memory: Output<Double>? = null,
    public val plainHttpRegistry: Output<String>? = null,
    public val ramRoleName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val restartPolicy: Output<String>? = null,
    public val securityContext: Output<ContainerGroupSecurityContextArgs>? = null,
    public val securityGroupId: Output<String>? = null,
    public val spotPriceLimit: Output<Double>? = null,
    public val spotStrategy: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val terminationGracePeriodSeconds: Output<Int>? = null,
    public val volumes: Output<List<ContainerGroupVolumeArgs>>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.ContainerGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.ContainerGroupArgs =
        com.pulumi.alicloud.eci.ContainerGroupArgs.builder()
            .acrRegistryInfos(
                acrRegistryInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .autoCreateEip(autoCreateEip?.applyValue({ args0 -> args0 }))
            .autoMatchImageCache(autoMatchImageCache?.applyValue({ args0 -> args0 }))
            .containerGroupName(containerGroupName?.applyValue({ args0 -> args0 }))
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .dnsConfig(dnsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eipBandwidth(eipBandwidth?.applyValue({ args0 -> args0 }))
            .eipInstanceId(eipInstanceId?.applyValue({ args0 -> args0 }))
            .hostAliases(
                hostAliases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageRegistryCredentials(
                imageRegistryCredentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .initContainers(
                initContainers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .insecureRegistry(insecureRegistry?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 }))
            .plainHttpRegistry(plainHttpRegistry?.applyValue({ args0 -> args0 }))
            .ramRoleName(ramRoleName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .restartPolicy(restartPolicy?.applyValue({ args0 -> args0 }))
            .securityContext(securityContext?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .spotPriceLimit(spotPriceLimit?.applyValue({ args0 -> args0 }))
            .spotStrategy(spotStrategy?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .terminationGracePeriodSeconds(terminationGracePeriodSeconds?.applyValue({ args0 -> args0 }))
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupArgs].
 */
@PulumiTagMarker
public class ContainerGroupArgsBuilder internal constructor() {
    private var acrRegistryInfos: Output<List<ContainerGroupAcrRegistryInfoArgs>>? = null

    private var autoCreateEip: Output<Boolean>? = null

    private var autoMatchImageCache: Output<Boolean>? = null

    private var containerGroupName: Output<String>? = null

    private var containers: Output<List<ContainerGroupContainerArgs>>? = null

    private var cpu: Output<Double>? = null

    private var dnsConfig: Output<ContainerGroupDnsConfigArgs>? = null

    private var eipBandwidth: Output<Int>? = null

    private var eipInstanceId: Output<String>? = null

    private var hostAliases: Output<List<ContainerGroupHostAliasArgs>>? = null

    private var imageRegistryCredentials: Output<List<ContainerGroupImageRegistryCredentialArgs>>? =
        null

    private var initContainers: Output<List<ContainerGroupInitContainerArgs>>? = null

    private var insecureRegistry: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var memory: Output<Double>? = null

    private var plainHttpRegistry: Output<String>? = null

    private var ramRoleName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var restartPolicy: Output<String>? = null

    private var securityContext: Output<ContainerGroupSecurityContextArgs>? = null

    private var securityGroupId: Output<String>? = null

    private var spotPriceLimit: Output<Double>? = null

    private var spotStrategy: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var terminationGracePeriodSeconds: Output<Int>? = null

    private var volumes: Output<List<ContainerGroupVolumeArgs>>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The ACR enterprise edition example properties. See `acr_registry_info` below.
     */
    @JvmName("cyqnkegvwxcmsyia")
    public suspend fun acrRegistryInfos(`value`: Output<List<ContainerGroupAcrRegistryInfoArgs>>) {
        this.acrRegistryInfos = value
    }

    @JvmName("eemibtubycxmmsdp")
    public suspend fun acrRegistryInfos(vararg values: Output<ContainerGroupAcrRegistryInfoArgs>) {
        this.acrRegistryInfos = Output.all(values.asList())
    }

    /**
     * @param values The ACR enterprise edition example properties. See `acr_registry_info` below.
     */
    @JvmName("awqpsncntcblvicp")
    public suspend fun acrRegistryInfos(values: List<Output<ContainerGroupAcrRegistryInfoArgs>>) {
        this.acrRegistryInfos = Output.all(values)
    }

    /**
     * @param value Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
     */
    @JvmName("ilvukbuychhpkara")
    public suspend fun autoCreateEip(`value`: Output<Boolean>) {
        this.autoCreateEip = value
    }

    /**
     * @param value Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
     */
    @JvmName("blgwwhjxgjnjygva")
    public suspend fun autoMatchImageCache(`value`: Output<Boolean>) {
        this.autoMatchImageCache = value
    }

    /**
     * @param value The name of the container group.
     */
    @JvmName("qbeatyevecvvqauc")
    public suspend fun containerGroupName(`value`: Output<String>) {
        this.containerGroupName = value
    }

    /**
     * @param value The list of containers. See `containers` below.
     */
    @JvmName("hrcxlflfmbtwjujm")
    public suspend fun containers(`value`: Output<List<ContainerGroupContainerArgs>>) {
        this.containers = value
    }

    @JvmName("gatthgexfggbdpic")
    public suspend fun containers(vararg values: Output<ContainerGroupContainerArgs>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values The list of containers. See `containers` below.
     */
    @JvmName("xmgikeowdcrrfdeu")
    public suspend fun containers(values: List<Output<ContainerGroupContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value The amount of CPU resources allocated to the container group.
     */
    @JvmName("fvymkaiqsxrwtncu")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The structure of dnsConfig. See `dns_config` below.
     */
    @JvmName("iigjlxiquykqboly")
    public suspend fun dnsConfig(`value`: Output<ContainerGroupDnsConfigArgs>) {
        this.dnsConfig = value
    }

    /**
     * @param value The bandwidth of the EIP. Default value: `5`.
     */
    @JvmName("ledhqkqxvnrsyoua")
    public suspend fun eipBandwidth(`value`: Output<Int>) {
        this.eipBandwidth = value
    }

    /**
     * @param value The ID of the elastic IP address (EIP).
     */
    @JvmName("kchvskcvpgtmwsfu")
    public suspend fun eipInstanceId(`value`: Output<String>) {
        this.eipInstanceId = value
    }

    /**
     * @param value HostAliases. See `host_aliases` below.
     */
    @JvmName("ilqvkirujmkndfge")
    public suspend fun hostAliases(`value`: Output<List<ContainerGroupHostAliasArgs>>) {
        this.hostAliases = value
    }

    @JvmName("uapavwfxprgshwgi")
    public suspend fun hostAliases(vararg values: Output<ContainerGroupHostAliasArgs>) {
        this.hostAliases = Output.all(values.asList())
    }

    /**
     * @param values HostAliases. See `host_aliases` below.
     */
    @JvmName("fsikhwgkhkmqvmfb")
    public suspend fun hostAliases(values: List<Output<ContainerGroupHostAliasArgs>>) {
        this.hostAliases = Output.all(values)
    }

    /**
     * @param value The image registry credential. See `image_registry_credential` below.
     */
    @JvmName("lcbmijxgykqfcepf")
    public suspend fun imageRegistryCredentials(`value`: Output<List<ContainerGroupImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = value
    }

    @JvmName("lxprkklbikfkygdh")
    public suspend fun imageRegistryCredentials(vararg values: Output<ContainerGroupImageRegistryCredentialArgs>) {
        this.imageRegistryCredentials = Output.all(values.asList())
    }

    /**
     * @param values The image registry credential. See `image_registry_credential` below.
     */
    @JvmName("krbwcjigopkoynoj")
    public suspend fun imageRegistryCredentials(values: List<Output<ContainerGroupImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = Output.all(values)
    }

    /**
     * @param value The list of initContainers. See `init_containers` below.
     */
    @JvmName("llejyuicmalkemlg")
    public suspend fun initContainers(`value`: Output<List<ContainerGroupInitContainerArgs>>) {
        this.initContainers = value
    }

    @JvmName("ibdvaoyhsvrakpxu")
    public suspend fun initContainers(vararg values: Output<ContainerGroupInitContainerArgs>) {
        this.initContainers = Output.all(values.asList())
    }

    /**
     * @param values The list of initContainers. See `init_containers` below.
     */
    @JvmName("kmafltsbfdylhnqu")
    public suspend fun initContainers(values: List<Output<ContainerGroupInitContainerArgs>>) {
        this.initContainers = Output.all(values)
    }

    /**
     * @param value The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
     */
    @JvmName("xvvcgarhfmbsfqiv")
    public suspend fun insecureRegistry(`value`: Output<String>) {
        this.insecureRegistry = value
    }

    /**
     * @param value The type of the ECS instance.
     */
    @JvmName("itptbtrrdrffkhdp")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The amount of memory resources allocated to the container group.
     */
    @JvmName("cixvuowxstyvsvqo")
    public suspend fun memory(`value`: Output<Double>) {
        this.memory = value
    }

    /**
     * @param value The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
     */
    @JvmName("cisprrvtrlvrjyja")
    public suspend fun plainHttpRegistry(`value`: Output<String>) {
        this.plainHttpRegistry = value
    }

    /**
     * @param value The RAM role that the container group assumes. ECI and ECS share the same RAM role.
     */
    @JvmName("qsdurcodwfcfqujr")
    public suspend fun ramRoleName(`value`: Output<String>) {
        this.ramRoleName = value
    }

    /**
     * @param value The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
     */
    @JvmName("ithqcjckthtugkpc")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
     */
    @JvmName("fkgaoqloycsxoifh")
    public suspend fun restartPolicy(`value`: Output<String>) {
        this.restartPolicy = value
    }

    /**
     * @param value The security context of the container group. See `security_context` below.
     */
    @JvmName("toevjgvkiqljmtck")
    public suspend fun securityContext(`value`: Output<ContainerGroupSecurityContextArgs>) {
        this.securityContext = value
    }

    /**
     * @param value The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
     */
    @JvmName("ormjvngdjngcrxlw")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The maximum hourly price of the ECI spot instance.
     */
    @JvmName("ombqxdlpshcglejw")
    public suspend fun spotPriceLimit(`value`: Output<Double>) {
        this.spotPriceLimit = value
    }

    /**
     * @param value Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
     */
    @JvmName("hlqoawpqorglspvp")
    public suspend fun spotStrategy(`value`: Output<String>) {
        this.spotStrategy = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("bllvqpdqeyygswqq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The buffer time during which the program handles operations before the program stops. Unit: seconds.
     */
    @JvmName("vkwdogkoslbyadjp")
    public suspend fun terminationGracePeriodSeconds(`value`: Output<Int>) {
        this.terminationGracePeriodSeconds = value
    }

    /**
     * @param value The list of volumes. See `volumes` below.
     */
    @JvmName("adlieaweejcsgcyv")
    public suspend fun volumes(`value`: Output<List<ContainerGroupVolumeArgs>>) {
        this.volumes = value
    }

    @JvmName("naepntobxeldvuur")
    public suspend fun volumes(vararg values: Output<ContainerGroupVolumeArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values The list of volumes. See `volumes` below.
     */
    @JvmName("cmawmvnsecnauaob")
    public suspend fun volumes(values: List<Output<ContainerGroupVolumeArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
     * **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
     */
    @JvmName("djlwcnkvovmmnfvd")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
     */
    @JvmName("xcvalyfpmvvhtfhi")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The ACR enterprise edition example properties. See `acr_registry_info` below.
     */
    @JvmName("pxryriyejtaemaey")
    public suspend fun acrRegistryInfos(`value`: List<ContainerGroupAcrRegistryInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrRegistryInfos = mapped
    }

    /**
     * @param argument The ACR enterprise edition example properties. See `acr_registry_info` below.
     */
    @JvmName("akkyoyfwgeqelsuf")
    public suspend fun acrRegistryInfos(argument: List<suspend ContainerGroupAcrRegistryInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupAcrRegistryInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.acrRegistryInfos = mapped
    }

    /**
     * @param argument The ACR enterprise edition example properties. See `acr_registry_info` below.
     */
    @JvmName("atrtmyrsbaoucjns")
    public suspend fun acrRegistryInfos(vararg argument: suspend ContainerGroupAcrRegistryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupAcrRegistryInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.acrRegistryInfos = mapped
    }

    /**
     * @param argument The ACR enterprise edition example properties. See `acr_registry_info` below.
     */
    @JvmName("sfgypofyrgnxgjin")
    public suspend fun acrRegistryInfos(argument: suspend ContainerGroupAcrRegistryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupAcrRegistryInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.acrRegistryInfos = mapped
    }

    /**
     * @param values The ACR enterprise edition example properties. See `acr_registry_info` below.
     */
    @JvmName("hkckejfuesxgbeie")
    public suspend fun acrRegistryInfos(vararg values: ContainerGroupAcrRegistryInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acrRegistryInfos = mapped
    }

    /**
     * @param value Specifies whether to automatically create an EIP and bind the EIP to the elastic container instance.
     */
    @JvmName("ubljaggaiixwyxix")
    public suspend fun autoCreateEip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCreateEip = mapped
    }

    /**
     * @param value Specifies whether to automatically match the image cache. Default value: `false`. Valid values: `true` and `false`.
     */
    @JvmName("guraayxoisdvgnyh")
    public suspend fun autoMatchImageCache(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoMatchImageCache = mapped
    }

    /**
     * @param value The name of the container group.
     */
    @JvmName("vpvycialndmrrych")
    public suspend fun containerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerGroupName = mapped
    }

    /**
     * @param value The list of containers. See `containers` below.
     */
    @JvmName("irwgqptnijbpdbtl")
    public suspend fun containers(`value`: List<ContainerGroupContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument The list of containers. See `containers` below.
     */
    @JvmName("wcyobltbxfdhsrfe")
    public suspend fun containers(argument: List<suspend ContainerGroupContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument The list of containers. See `containers` below.
     */
    @JvmName("kjhpyoydulfxuipv")
    public suspend fun containers(vararg argument: suspend ContainerGroupContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument The list of containers. See `containers` below.
     */
    @JvmName("ywmeainmyidiwwdl")
    public suspend fun containers(argument: suspend ContainerGroupContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values The list of containers. See `containers` below.
     */
    @JvmName("edtgmmlccgmpuvhe")
    public suspend fun containers(vararg values: ContainerGroupContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value The amount of CPU resources allocated to the container group.
     */
    @JvmName("gdxnaoyjeunmcoio")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The structure of dnsConfig. See `dns_config` below.
     */
    @JvmName("vsmrnthbymbatnss")
    public suspend fun dnsConfig(`value`: ContainerGroupDnsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsConfig = mapped
    }

    /**
     * @param argument The structure of dnsConfig. See `dns_config` below.
     */
    @JvmName("smfufytcycmjosxy")
    public suspend fun dnsConfig(argument: suspend ContainerGroupDnsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerGroupDnsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsConfig = mapped
    }

    /**
     * @param value The bandwidth of the EIP. Default value: `5`.
     */
    @JvmName("vivdfcctduyhmbrm")
    public suspend fun eipBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipBandwidth = mapped
    }

    /**
     * @param value The ID of the elastic IP address (EIP).
     */
    @JvmName("hxqoilpryokxkerc")
    public suspend fun eipInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipInstanceId = mapped
    }

    /**
     * @param value HostAliases. See `host_aliases` below.
     */
    @JvmName("yejdtculolutnrhw")
    public suspend fun hostAliases(`value`: List<ContainerGroupHostAliasArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostAliases = mapped
    }

    /**
     * @param argument HostAliases. See `host_aliases` below.
     */
    @JvmName("glbnmxxmisukbfdq")
    public suspend fun hostAliases(argument: List<suspend ContainerGroupHostAliasArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupHostAliasArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hostAliases = mapped
    }

    /**
     * @param argument HostAliases. See `host_aliases` below.
     */
    @JvmName("nacmrqkohrsdayny")
    public suspend fun hostAliases(vararg argument: suspend ContainerGroupHostAliasArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupHostAliasArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hostAliases = mapped
    }

    /**
     * @param argument HostAliases. See `host_aliases` below.
     */
    @JvmName("xdpdljxmavtleabt")
    public suspend fun hostAliases(argument: suspend ContainerGroupHostAliasArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupHostAliasArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.hostAliases = mapped
    }

    /**
     * @param values HostAliases. See `host_aliases` below.
     */
    @JvmName("yfuwmammwmigjets")
    public suspend fun hostAliases(vararg values: ContainerGroupHostAliasArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostAliases = mapped
    }

    /**
     * @param value The image registry credential. See `image_registry_credential` below.
     */
    @JvmName("pfblqecluvphrule")
    public suspend fun imageRegistryCredentials(`value`: List<ContainerGroupImageRegistryCredentialArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The image registry credential. See `image_registry_credential` below.
     */
    @JvmName("oxojykhlfbapkcfm")
    public suspend fun imageRegistryCredentials(argument: List<suspend ContainerGroupImageRegistryCredentialArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupImageRegistryCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The image registry credential. See `image_registry_credential` below.
     */
    @JvmName("bfbioypkmbkumsps")
    public suspend fun imageRegistryCredentials(vararg argument: suspend ContainerGroupImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupImageRegistryCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The image registry credential. See `image_registry_credential` below.
     */
    @JvmName("jdkmsrcijrwenqjt")
    public suspend fun imageRegistryCredentials(argument: suspend ContainerGroupImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupImageRegistryCredentialArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param values The image registry credential. See `image_registry_credential` below.
     */
    @JvmName("idxxwxlhpcbylyqq")
    public suspend fun imageRegistryCredentials(vararg values: ContainerGroupImageRegistryCredentialArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param value The list of initContainers. See `init_containers` below.
     */
    @JvmName("tdmlhtphweeqxibt")
    public suspend fun initContainers(`value`: List<ContainerGroupInitContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param argument The list of initContainers. See `init_containers` below.
     */
    @JvmName("glpllccocfnihhcf")
    public suspend fun initContainers(argument: List<suspend ContainerGroupInitContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument The list of initContainers. See `init_containers` below.
     */
    @JvmName("illxyfaqijemjylw")
    public suspend fun initContainers(vararg argument: suspend ContainerGroupInitContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument The list of initContainers. See `init_containers` below.
     */
    @JvmName("nluiwnaxstncdlmr")
    public suspend fun initContainers(argument: suspend ContainerGroupInitContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupInitContainerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param values The list of initContainers. See `init_containers` below.
     */
    @JvmName("tvxkdlikwqnskbsd")
    public suspend fun initContainers(vararg values: ContainerGroupInitContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param value The address of the self-built mirror warehouse. When creating an image cache using an image in a self-built image repository with a self-signed certificate, you need to configure this parameter to skip certificate authentication to avoid image pull failure due to certificate authentication failure.
     */
    @JvmName("hipgwywsatdwqmny")
    public suspend fun insecureRegistry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insecureRegistry = mapped
    }

    /**
     * @param value The type of the ECS instance.
     */
    @JvmName("saiqnllnypuwiuho")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The amount of memory resources allocated to the container group.
     */
    @JvmName("pwcinhckurxkphrs")
    public suspend fun memory(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value The address of the self-built mirror warehouse. When creating an image cache from an image in a self-built image repository using the HTTP protocol, you need to configure this parameter so that the ECI uses the HTTP protocol to pull the image to avoid image pull failure due to different protocols.
     */
    @JvmName("dhiduwsnnakvbybp")
    public suspend fun plainHttpRegistry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plainHttpRegistry = mapped
    }

    /**
     * @param value The RAM role that the container group assumes. ECI and ECS share the same RAM role.
     */
    @JvmName("lstdixllmbstsgns")
    public suspend fun ramRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramRoleName = mapped
    }

    /**
     * @param value The ID of the resource group. **NOTE:** From version 1.208.0, `resource_group_id` can be modified.
     */
    @JvmName("bukqajiadhoytcjm")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The restart policy of the container group. Valid values: `Always`, `Never`, `OnFailure`.
     */
    @JvmName("gprjkjgxkcwtltqu")
    public suspend fun restartPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartPolicy = mapped
    }

    /**
     * @param value The security context of the container group. See `security_context` below.
     */
    @JvmName("xhbacnowrcrkjchw")
    public suspend fun securityContext(`value`: ContainerGroupSecurityContextArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContext = mapped
    }

    /**
     * @param argument The security context of the container group. See `security_context` below.
     */
    @JvmName("acnophdcddbdssfv")
    public suspend fun securityContext(argument: suspend ContainerGroupSecurityContextArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerGroupSecurityContextArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityContext = mapped
    }

    /**
     * @param value The ID of the security group to which the container group belongs. Container groups within the same security group can access each other.
     */
    @JvmName("mwjxyfyocvymaiau")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The maximum hourly price of the ECI spot instance.
     */
    @JvmName("hidjisfdmiojkfhj")
    public suspend fun spotPriceLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriceLimit = mapped
    }

    /**
     * @param value Filter the results by ECI spot type. Valid values: `NoSpot`, `SpotWithPriceLimit` and `SpotAsPriceGo`. Default to `NoSpot`.
     */
    @JvmName("tmqbiibtpmpoirhc")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotStrategy = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("prgxctixcuyljgmo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("avcehvyfwqlaissj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The buffer time during which the program handles operations before the program stops. Unit: seconds.
     */
    @JvmName("maqeougqimpkqwpu")
    public suspend fun terminationGracePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationGracePeriodSeconds = mapped
    }

    /**
     * @param value The list of volumes. See `volumes` below.
     */
    @JvmName("ffuunpfanjohlgfx")
    public suspend fun volumes(`value`: List<ContainerGroupVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument The list of volumes. See `volumes` below.
     */
    @JvmName("hqobkgrmaxjoudrp")
    public suspend fun volumes(argument: List<suspend ContainerGroupVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument The list of volumes. See `volumes` below.
     */
    @JvmName("wyytdjfcbkuyjtmd")
    public suspend fun volumes(vararg argument: suspend ContainerGroupVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupVolumeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument The list of volumes. See `volumes` below.
     */
    @JvmName("kbjelxfnlsloroks")
    public suspend fun volumes(argument: suspend ContainerGroupVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerGroupVolumeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values The list of volumes. See `volumes` below.
     */
    @JvmName("dmrrvikhuhfimhsx")
    public suspend fun volumes(vararg values: ContainerGroupVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param value The ID of the VSwitch. Currently, container groups can only be deployed in VPC networks. The number of IP addresses in the VSwitch CIDR block determines the maximum number of container groups that can be created in the VSwitch. Before you can create an ECI instance, plan the CIDR block of the VSwitch.
     * **NOTE:** From version 1.208.0, You can specify up to 10 `vswitch_id`. Separate multiple vSwitch IDs with commas (,), such as vsw-***,vsw-***.  attribute `vswitch_id` updating diff will be ignored when you set multiple vSwitchIds, there is only one valid `vswitch_id` exists in the set vSwitchIds.
     */
    @JvmName("nwqdapvjuulrulyf")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
     */
    @JvmName("fppwfppxnoemlgke")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ContainerGroupArgs = ContainerGroupArgs(
        acrRegistryInfos = acrRegistryInfos,
        autoCreateEip = autoCreateEip,
        autoMatchImageCache = autoMatchImageCache,
        containerGroupName = containerGroupName,
        containers = containers,
        cpu = cpu,
        dnsConfig = dnsConfig,
        eipBandwidth = eipBandwidth,
        eipInstanceId = eipInstanceId,
        hostAliases = hostAliases,
        imageRegistryCredentials = imageRegistryCredentials,
        initContainers = initContainers,
        insecureRegistry = insecureRegistry,
        instanceType = instanceType,
        memory = memory,
        plainHttpRegistry = plainHttpRegistry,
        ramRoleName = ramRoleName,
        resourceGroupId = resourceGroupId,
        restartPolicy = restartPolicy,
        securityContext = securityContext,
        securityGroupId = securityGroupId,
        spotPriceLimit = spotPriceLimit,
        spotStrategy = spotStrategy,
        tags = tags,
        terminationGracePeriodSeconds = terminationGracePeriodSeconds,
        volumes = volumes,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
