@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin

import com.pulumi.alicloud.eci.EciFunctions.getContainerGroupsPlain
import com.pulumi.alicloud.eci.EciFunctions.getImageCachesPlain
import com.pulumi.alicloud.eci.EciFunctions.getVirtualNodesPlain
import com.pulumi.alicloud.eci.EciFunctions.getZonesPlain
import com.pulumi.alicloud.eci.kotlin.inputs.GetContainerGroupsPlainArgs
import com.pulumi.alicloud.eci.kotlin.inputs.GetContainerGroupsPlainArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.GetImageCachesPlainArgs
import com.pulumi.alicloud.eci.kotlin.inputs.GetImageCachesPlainArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.GetVirtualNodesPlainArgs
import com.pulumi.alicloud.eci.kotlin.inputs.GetVirtualNodesPlainArgsBuilder
import com.pulumi.alicloud.eci.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.eci.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsResult
import com.pulumi.alicloud.eci.kotlin.outputs.GetImageCachesResult
import com.pulumi.alicloud.eci.kotlin.outputs.GetVirtualNodesResult
import com.pulumi.alicloud.eci.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.eci.kotlin.outputs.GetContainerGroupsResult.Companion.toKotlin as getContainerGroupsResultToKotlin
import com.pulumi.alicloud.eci.kotlin.outputs.GetImageCachesResult.Companion.toKotlin as getImageCachesResultToKotlin
import com.pulumi.alicloud.eci.kotlin.outputs.GetVirtualNodesResult.Companion.toKotlin as getVirtualNodesResultToKotlin
import com.pulumi.alicloud.eci.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object EciFunctions {
    /**
     * This data source provides the Eci Container Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.111.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.eci.getContainerGroups({
     *     ids: ["example_value"],
     * });
     * export const firstEciContainerGroupId = example.then(example => example.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.eci.get_container_groups(ids=["example_value"])
     * pulumi.export("firstEciContainerGroupId", example.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Eci.GetContainerGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEciContainerGroupId"] = example&#46;Apply(getContainerGroupsResult => getContainerGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eci"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := eci.GetContainerGroups(ctx, &eci.GetContainerGroupsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEciContainerGroupId", example.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eci.EciFunctions;
     * import com.pulumi.alicloud.eci.inputs.GetContainerGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EciFunctions.getContainerGroups(GetContainerGroupsArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("firstEciContainerGroupId", example.applyValue(getContainerGroupsResult -> getContainerGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:eci:getContainerGroups
     *       Arguments:
     *         ids:
     *           - example_value
     * outputs:
     *   firstEciContainerGroupId: ${example.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getContainerGroups.
     * @return A collection of values returned by getContainerGroups.
     */
    public suspend fun getContainerGroups(argument: GetContainerGroupsPlainArgs): GetContainerGroupsResult =
        getContainerGroupsResultToKotlin(getContainerGroupsPlain(argument.toJava()).await())

    /**
     * @see [getContainerGroups].
     * @param containerGroupName The name of ContainerGroup.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Container Group IDs.
     * @param limit The maximum number of resources returned in the response. Default value is `20`. Maximum value: `20`. The number of returned results is no greater than the specified number.
     * @param nameRegex A regex string to filter results by Container Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group to which the container group belongs. If you have not specified a resource group for the container group, it is added to the default resource group.
     * @param status The status list. For more information, see the description of ContainerGroup arrays.
     * @param tags
     * @param vswitchId The ID of the vSwitch. Currently, container groups can only be deployed in VPC networks.
     * @param withEvent
     * @param zoneId The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
     * @return A collection of values returned by getContainerGroups.
     */
    public suspend fun getContainerGroups(
        containerGroupName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        limit: Int? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vswitchId: String? = null,
        withEvent: Boolean? = null,
        zoneId: String? = null,
    ): GetContainerGroupsResult {
        val argument = GetContainerGroupsPlainArgs(
            containerGroupName = containerGroupName,
            enableDetails = enableDetails,
            ids = ids,
            limit = limit,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
            vswitchId = vswitchId,
            withEvent = withEvent,
            zoneId = zoneId,
        )
        return getContainerGroupsResultToKotlin(getContainerGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eci&#46;kotlin&#46;inputs&#46;GetContainerGroupsPlainArgs].
     * @return A collection of values returned by getContainerGroups.
     */
    public suspend fun getContainerGroups(argument: suspend GetContainerGroupsPlainArgsBuilder.() -> Unit): GetContainerGroupsResult {
        val builder = GetContainerGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerGroupsResultToKotlin(getContainerGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a collection of ECI Image Cache to the specified filters.
     * > **NOTE:** Available in 1.90.0+.
     * ## Example Usage
     *  <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.eci.getImageCaches({
     *     ids: ["imc-bp1ef0dyp7ldhb1d****"],
     * });
     * export const imageCache = example.then(example => example.caches?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.eci.get_image_caches(ids=["imc-bp1ef0dyp7ldhb1d****"])
     * pulumi.export("imageCache", example.caches[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Eci.GetImageCaches.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "imc-bp1ef0dyp7ldhb1d****",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["imageCache"] = example&#46;Apply(getImageCachesResult => getImageCachesResult&#46;Caches[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eci"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := eci.GetImageCaches(ctx, &eci.GetImageCachesArgs{
     * 			Ids: []string{
     * 				"imc-bp1ef0dyp7ldhb1d****",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("imageCache", example.Caches[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eci.EciFunctions;
     * import com.pulumi.alicloud.eci.inputs.GetImageCachesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EciFunctions.getImageCaches(GetImageCachesArgs.builder()
     *             .ids("imc-bp1ef0dyp7ldhb1d****")
     *             .build());
     *         ctx.export("imageCache", example.applyValue(getImageCachesResult -> getImageCachesResult.caches()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:eci:getImageCaches
     *       Arguments:
     *         ids:
     *           - imc-bp1ef0dyp7ldhb1d****
     * outputs:
     *   imageCache: ${example.caches[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getImageCaches.
     * @return A collection of values returned by getImageCaches.
     */
    public suspend fun getImageCaches(argument: GetImageCachesPlainArgs): GetImageCachesResult =
        getImageCachesResultToKotlin(getImageCachesPlain(argument.toJava()).await())

    /**
     * @see [getImageCaches].
     * @param ids A list ids of ECI Image Cache.
     * @param image Find the mirror cache containing it according to the image name.
     * @param imageCacheName The name of ECI Image Cache.
     * @param nameRegex A regex string to filter results by the image cache name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param snapshotId The id of snapshot.
     * @param status The status of ECI Image Cache.
     * @return A collection of values returned by getImageCaches.
     */
    public suspend fun getImageCaches(
        ids: List<String>? = null,
        image: String? = null,
        imageCacheName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        snapshotId: String? = null,
        status: String? = null,
    ): GetImageCachesResult {
        val argument = GetImageCachesPlainArgs(
            ids = ids,
            image = image,
            imageCacheName = imageCacheName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            snapshotId = snapshotId,
            status = status,
        )
        return getImageCachesResultToKotlin(getImageCachesPlain(argument.toJava()).await())
    }

    /**
     * @see [getImageCaches].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eci&#46;kotlin&#46;inputs&#46;GetImageCachesPlainArgs].
     * @return A collection of values returned by getImageCaches.
     */
    public suspend fun getImageCaches(argument: suspend GetImageCachesPlainArgsBuilder.() -> Unit): GetImageCachesResult {
        val builder = GetImageCachesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageCachesResultToKotlin(getImageCachesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Eci Virtual Nodes of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.145.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.eci.getVirtualNodes({
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const eciVirtualNodeId1 = ids.then(ids => ids.nodes?.[0]?.id);
     * const nameRegex = alicloud.eci.getVirtualNodes({
     *     nameRegex: "^my-VirtualNode",
     * });
     * export const eciVirtualNodeId2 = nameRegex.then(nameRegex => nameRegex.nodes?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.eci.get_virtual_nodes(ids=[
     *     "example_value-1",
     *     "example_value-2",
     * ])
     * pulumi.export("eciVirtualNodeId1", ids.nodes[0].id)
     * name_regex = alicloud.eci.get_virtual_nodes(name_regex="^my-VirtualNode")
     * pulumi.export("eciVirtualNodeId2", name_regex.nodes[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Eci.GetVirtualNodes.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var nameRegex = AliCloud.Eci.GetVirtualNodes.Invoke(new()
     *     {
     *         NameRegex = "^my-VirtualNode",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["eciVirtualNodeId1"] = ids&#46;Apply(getVirtualNodesResult => getVirtualNodesResult&#46;Nodes[0]?.Id),
     *         ["eciVirtualNodeId2"] = nameRegex&#46;Apply(getVirtualNodesResult => getVirtualNodesResult&#46;Nodes[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eci"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := eci.GetVirtualNodes(ctx, &eci.GetVirtualNodesArgs{
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("eciVirtualNodeId1", ids.Nodes[0].Id)
     * 		nameRegex, err := eci.GetVirtualNodes(ctx, &eci.GetVirtualNodesArgs{
     * 			NameRegex: pulumi.StringRef("^my-VirtualNode"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("eciVirtualNodeId2", nameRegex.Nodes[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eci.EciFunctions;
     * import com.pulumi.alicloud.eci.inputs.GetVirtualNodesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = EciFunctions.getVirtualNodes(GetVirtualNodesArgs.builder()
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("eciVirtualNodeId1", ids.applyValue(getVirtualNodesResult -> getVirtualNodesResult.nodes()[0].id()));
     *         final var nameRegex = EciFunctions.getVirtualNodes(GetVirtualNodesArgs.builder()
     *             .nameRegex("^my-VirtualNode")
     *             .build());
     *         ctx.export("eciVirtualNodeId2", nameRegex.applyValue(getVirtualNodesResult -> getVirtualNodesResult.nodes()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:eci:getVirtualNodes
     *       Arguments:
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:eci:getVirtualNodes
     *       Arguments:
     *         nameRegex: ^my-VirtualNode
     * outputs:
     *   eciVirtualNodeId1: ${ids.nodes[0].id}
     *   eciVirtualNodeId2: ${nameRegex.nodes[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVirtualNodes.
     * @return A collection of values returned by getVirtualNodes.
     */
    public suspend fun getVirtualNodes(argument: GetVirtualNodesPlainArgs): GetVirtualNodesResult =
        getVirtualNodesResultToKotlin(getVirtualNodesPlain(argument.toJava()).await())

    /**
     * @see [getVirtualNodes].
     * @param ids A list of Virtual Node IDs.
     * @param nameRegex A regex string to filter results by Virtual Node name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The resource group ID. If when you create a GPU does not specify a resource group instance will automatically add the account's default resource group.
     * @param securityGroupId VNode itself and by VNode created (ECI) the security group used by.
     * @param status The Status of the virtual node. Valid values: `Cleaned`, `Failed`, `Pending`, `Ready`.
     * @param tags A mapping of tags to assign to the resource.
     * @param virtualNodeName The name of the virtual node.
     * @param vswitchId
     * @return A collection of values returned by getVirtualNodes.
     */
    public suspend fun getVirtualNodes(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        securityGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        virtualNodeName: String? = null,
        vswitchId: String? = null,
    ): GetVirtualNodesResult {
        val argument = GetVirtualNodesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            securityGroupId = securityGroupId,
            status = status,
            tags = tags,
            virtualNodeName = virtualNodeName,
            vswitchId = vswitchId,
        )
        return getVirtualNodesResultToKotlin(getVirtualNodesPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNodes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eci&#46;kotlin&#46;inputs&#46;GetVirtualNodesPlainArgs].
     * @return A collection of values returned by getVirtualNodes.
     */
    public suspend fun getVirtualNodes(argument: suspend GetVirtualNodesPlainArgsBuilder.() -> Unit): GetVirtualNodesResult {
        val builder = GetVirtualNodesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNodesResultToKotlin(getVirtualNodesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the available zones with the Application Load Balancer (ALB) Instance of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.145.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.eci.getZones({});
     * export const firstEciZonesId = _default.then(_default => _default.zones?.[0]?&#46;zoneIds?&#46;[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.eci.get_zones()
     * pulumi.export("firstEciZonesId", default.zones[0]&#46;zone_ids[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Eci.GetZones.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstEciZonesId"] = @default&#46;Apply(@default => @default&#46;Apply(getZonesResult => getZonesResult&#46;Zones[0]?&#46;ZoneIds[0])),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eci"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := eci.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstEciZonesId", _default.Zones[0]&#46;ZoneIds[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.eci.EciFunctions;
     * import com.pulumi.alicloud.eci.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EciFunctions.getZones();
     *         ctx.export("firstEciZonesId", default_.zones()[0]&#46;zoneIds()[0]);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:eci:getZones
     *       Arguments: {}
     * outputs:
     *   firstEciZonesId: ${default.zones[0]&#46;zoneIds[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;eci&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
