@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin

import com.pulumi.alicloud.eci.kotlin.outputs.ImageCacheImageRegistryCredential
import com.pulumi.alicloud.eci.kotlin.outputs.ImageCacheImageRegistryCredential.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ImageCache].
 */
@PulumiTagMarker
public class ImageCacheResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageCacheArgs = ImageCacheArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageCacheArgsBuilder.() -> Unit) {
        val builder = ImageCacheArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ImageCache {
        val builtJavaResource = com.pulumi.alicloud.eci.ImageCache(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ImageCache(builtJavaResource)
    }
}

/**
 * An ECI Image Cache can help user to solve the time-consuming problem of image pull. For information about Alicloud ECI Image Cache and how to use it, see [What is Resource Alicloud ECI Image Cache](https://www.alibabacloud.com/help/doc-detail/146891.htm).
 * > **NOTE:** Available since v1.89.0.
 * > **NOTE:** Each image cache corresponds to a snapshot, and the user does not delete the snapshot directly, otherwise the cache will fail.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.eci.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.1.0.0/16",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?&#46;zoneIds?&#46;[0]),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {
 *     isp: "BGP",
 *     addressName: name,
 *     netmode: "public",
 *     bandwidth: "1",
 *     securityProtectionTypes: ["AntiDDoS_Enhanced"],
 *     paymentType: "PayAsYouGo",
 * });
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultImageCache = new alicloud.eci.ImageCache("default", {
 *     imageCacheName: name,
 *     images: [defaultGetRegions&#46;then(defaultGetRegions => `registry-vpc&#46;${defaultGetRegions&#46;regions?&#46;[0]?&#46;id}&#46;aliyuncs&#46;com/eci_open/nginx:alpine`)],
 *     securityGroupId: defaultSecurityGroup.id,
 *     vswitchId: defaultSwitch.id,
 *     eipInstanceId: defaultEipAddress.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.eci.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.0.0.0/8")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.1.0.0/16",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0]&#46;zone_ids[0])
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_eip_address = alicloud.ecs.EipAddress("default",
 *     isp="BGP",
 *     address_name=name,
 *     netmode="public",
 *     bandwidth="1",
 *     security_protection_types=["AntiDDoS_Enhanced"],
 *     payment_type="PayAsYouGo")
 * default_get_regions = alicloud.get_regions(current=True)
 * default_image_cache = alicloud.eci.ImageCache("default",
 *     image_cache_name=name,
 *     images=[f"registry-vpc&#46;{default_get_regions&#46;regions[0]&#46;id}&#46;aliyuncs&#46;com/eci_open/nginx:alpine"],
 *     security_group_id=default_security_group.id,
 *     vswitch_id=default_switch.id,
 *     eip_instance_id=default_eip_address.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Eci.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.1.0.0/16",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?&#46;ZoneIds[0])),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         Isp = "BGP",
 *         AddressName = name,
 *         Netmode = "public",
 *         Bandwidth = "1",
 *         SecurityProtectionTypes = new[]
 *         {
 *             "AntiDDoS_Enhanced",
 *         },
 *         PaymentType = "PayAsYouGo",
 *     });
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultImageCache = new AliCloud.Eci.ImageCache("default", new()
 *     {
 *         ImageCacheName = name,
 *         Images = new[]
 *         {
 *             $"registry-vpc.{defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}.aliyuncs.com/eci_open/nginx:alpine",
 *         },
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         VswitchId = defaultSwitch.Id,
 *         EipInstanceId = defaultEipAddress.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eci"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := eci.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.1.0.0/16"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0]&#46;ZoneIds[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			Isp:         pulumi.String("BGP"),
 * 			AddressName: pulumi.String(name),
 * 			Netmode:     pulumi.String("public"),
 * 			Bandwidth:   pulumi.String("1"),
 * 			SecurityProtectionTypes: pulumi.StringArray{
 * 				pulumi.String("AntiDDoS_Enhanced"),
 * 			},
 * 			PaymentType: pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eci.NewImageCache(ctx, "default", &eci.ImageCacheArgs{
 * 			ImageCacheName: pulumi.String(name),
 * 			Images: pulumi.StringArray{
 * 				pulumi.Sprintf("registry-vpc.%v.aliyuncs.com/eci_open/nginx:alpine", defaultGetRegions.Regions[0].Id),
 * 			},
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			VswitchId:       defaultSwitch.ID(),
 * 			EipInstanceId:   defaultEipAddress.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eci.EciFunctions;
 * import com.pulumi.alicloud.eci.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.eci.ImageCache;
 * import com.pulumi.alicloud.eci.ImageCacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = EciFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.1.0.0/16")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0]&#46;zoneIds()[0])
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultEipAddress = new EipAddress("defaultEipAddress", EipAddressArgs.builder()
 *             .isp("BGP")
 *             .addressName(name)
 *             .netmode("public")
 *             .bandwidth("1")
 *             .securityProtectionTypes("AntiDDoS_Enhanced")
 *             .paymentType("PayAsYouGo")
 *             .build());
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultImageCache = new ImageCache("defaultImageCache", ImageCacheArgs.builder()
 *             .imageCacheName(name)
 *             .images(String.format("registry-vpc.%s.aliyuncs.com/eci_open/nginx:alpine", defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id())))
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .eipInstanceId(defaultEipAddress.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.0.0.0/8
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.1.0.0/16
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0]&#46;zoneIds[0]}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       isp: BGP
 *       addressName: ${name}
 *       netmode: public
 *       bandwidth: '1'
 *       securityProtectionTypes:
 *         - AntiDDoS_Enhanced
 *       paymentType: PayAsYouGo
 *   defaultImageCache:
 *     type: alicloud:eci:ImageCache
 *     name: default
 *     properties:
 *       imageCacheName: ${name}
 *       images:
 *         - registry-vpc.${defaultGetRegions.regions[0].id}.aliyuncs.com/eci_open/nginx:alpine
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       vswitchId: ${defaultSwitch.id}
 *       eipInstanceId: ${defaultEipAddress.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eci:getZones
 *       Arguments: {}
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECI Image Cache can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eci/imageCache:ImageCache example abc123456
 * ```
 */
public class ImageCache internal constructor(
    override val javaResource: com.pulumi.alicloud.eci.ImageCache,
) : KotlinCustomResource(javaResource, ImageCacheMapper) {
    /**
     * The ID of the container group job that is used to create the image cache.
     */
    public val containerGroupId: Output<String>
        get() = javaResource.containerGroupId().applyValue({ args0 -> args0 })

    /**
     * The instance ID of the Elastic IP Address (EIP). If you want to pull images from the Internet, you must specify an EIP to make sure that the container group can access the Internet. You can also configure the network address translation (NAT) gateway. We recommend that you configure the NAT gateway for the Internet access. Refer to [Public Network Access Method](https://help.aliyun.com/document_detail/99146.html)
     */
    public val eipInstanceId: Output<String>?
        get() = javaResource.eipInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the image cache.
     */
    public val imageCacheName: Output<String>
        get() = javaResource.imageCacheName().applyValue({ args0 -> args0 })

    /**
     * The size of the image cache. Default to `20`. Unit: GiB.
     */
    public val imageCacheSize: Output<Int>?
        get() = javaResource.imageCacheSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Image Registry parameters about the image to be cached. See `image_registry_credential` below.
     */
    public val imageRegistryCredentials: Output<List<ImageCacheImageRegistryCredential>>?
        get() = javaResource.imageRegistryCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The images to be cached. The image name must be versioned.
     */
    public val images: Output<List<String>>
        get() = javaResource.images().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The retention days of the image cache. Once the image cache expires, it will be cleared. By default, the image cache never expires. Note: The image cache that fails to be created is retained for only one day.
     */
    public val retentionDays: Output<Int>?
        get() = javaResource.retentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the security group. You do not need to specify the same security group as the container group.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the image cache.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The ID of the VSwitch. You do not need to specify the same VSwitch as the container group.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The zone id to cache image.
     */
    public val zoneId: Output<String>?
        get() = javaResource.zoneId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ImageCacheMapper : ResourceMapper<ImageCache> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eci.ImageCache::class == javaResource::class

    override fun map(javaResource: Resource): ImageCache = ImageCache(
        javaResource as
            com.pulumi.alicloud.eci.ImageCache,
    )
}

/**
 * @see [ImageCache].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImageCache].
 */
public suspend fun imageCache(name: String, block: suspend ImageCacheResourceBuilder.() -> Unit): ImageCache {
    val builder = ImageCacheResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImageCache].
 * @param name The _unique_ name of the resulting resource.
 */
public fun imageCache(name: String): ImageCache {
    val builder = ImageCacheResourceBuilder()
    builder.name(name)
    return builder.build()
}
