@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin

import com.pulumi.alicloud.eci.ImageCacheArgs.builder
import com.pulumi.alicloud.eci.kotlin.inputs.ImageCacheImageRegistryCredentialArgs
import com.pulumi.alicloud.eci.kotlin.inputs.ImageCacheImageRegistryCredentialArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An ECI Image Cache can help user to solve the time-consuming problem of image pull. For information about Alicloud ECI Image Cache and how to use it, see [What is Resource Alicloud ECI Image Cache](https://www.alibabacloud.com/help/doc-detail/146891.htm).
 * > **NOTE:** Available since v1.89.0.
 * > **NOTE:** Each image cache corresponds to a snapshot, and the user does not delete the snapshot directly, otherwise the cache will fail.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.eci.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.1.0.0/16",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?&#46;zoneIds?&#46;[0]),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {
 *     isp: "BGP",
 *     addressName: name,
 *     netmode: "public",
 *     bandwidth: "1",
 *     securityProtectionTypes: ["AntiDDoS_Enhanced"],
 *     paymentType: "PayAsYouGo",
 * });
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultImageCache = new alicloud.eci.ImageCache("default", {
 *     imageCacheName: name,
 *     images: [defaultGetRegions&#46;then(defaultGetRegions => `registry-vpc&#46;${defaultGetRegions&#46;regions?&#46;[0]?&#46;id}&#46;aliyuncs&#46;com/eci_open/nginx:alpine`)],
 *     securityGroupId: defaultSecurityGroup.id,
 *     vswitchId: defaultSwitch.id,
 *     eipInstanceId: defaultEipAddress.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.eci.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.0.0.0/8")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.1.0.0/16",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0]&#46;zone_ids[0])
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_eip_address = alicloud.ecs.EipAddress("default",
 *     isp="BGP",
 *     address_name=name,
 *     netmode="public",
 *     bandwidth="1",
 *     security_protection_types=["AntiDDoS_Enhanced"],
 *     payment_type="PayAsYouGo")
 * default_get_regions = alicloud.get_regions(current=True)
 * default_image_cache = alicloud.eci.ImageCache("default",
 *     image_cache_name=name,
 *     images=[f"registry-vpc&#46;{default_get_regions&#46;regions[0]&#46;id}&#46;aliyuncs&#46;com/eci_open/nginx:alpine"],
 *     security_group_id=default_security_group.id,
 *     vswitch_id=default_switch.id,
 *     eip_instance_id=default_eip_address.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Eci.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.1.0.0/16",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?&#46;ZoneIds[0])),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         Isp = "BGP",
 *         AddressName = name,
 *         Netmode = "public",
 *         Bandwidth = "1",
 *         SecurityProtectionTypes = new[]
 *         {
 *             "AntiDDoS_Enhanced",
 *         },
 *         PaymentType = "PayAsYouGo",
 *     });
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultImageCache = new AliCloud.Eci.ImageCache("default", new()
 *     {
 *         ImageCacheName = name,
 *         Images = new[]
 *         {
 *             $"registry-vpc.{defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}.aliyuncs.com/eci_open/nginx:alpine",
 *         },
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         VswitchId = defaultSwitch.Id,
 *         EipInstanceId = defaultEipAddress.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eci"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := eci.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.1.0.0/16"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0]&#46;ZoneIds[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			Isp:         pulumi.String("BGP"),
 * 			AddressName: pulumi.String(name),
 * 			Netmode:     pulumi.String("public"),
 * 			Bandwidth:   pulumi.String("1"),
 * 			SecurityProtectionTypes: pulumi.StringArray{
 * 				pulumi.String("AntiDDoS_Enhanced"),
 * 			},
 * 			PaymentType: pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eci.NewImageCache(ctx, "default", &eci.ImageCacheArgs{
 * 			ImageCacheName: pulumi.String(name),
 * 			Images: pulumi.StringArray{
 * 				pulumi.Sprintf("registry-vpc.%v.aliyuncs.com/eci_open/nginx:alpine", defaultGetRegions.Regions[0].Id),
 * 			},
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			VswitchId:       defaultSwitch.ID(),
 * 			EipInstanceId:   defaultEipAddress.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eci.EciFunctions;
 * import com.pulumi.alicloud.eci.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.eci.ImageCache;
 * import com.pulumi.alicloud.eci.ImageCacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = EciFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.1.0.0/16")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0]&#46;zoneIds()[0])
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultEipAddress = new EipAddress("defaultEipAddress", EipAddressArgs.builder()
 *             .isp("BGP")
 *             .addressName(name)
 *             .netmode("public")
 *             .bandwidth("1")
 *             .securityProtectionTypes("AntiDDoS_Enhanced")
 *             .paymentType("PayAsYouGo")
 *             .build());
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultImageCache = new ImageCache("defaultImageCache", ImageCacheArgs.builder()
 *             .imageCacheName(name)
 *             .images(String.format("registry-vpc.%s.aliyuncs.com/eci_open/nginx:alpine", defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id())))
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .vswitchId(defaultSwitch.id())
 *             .eipInstanceId(defaultEipAddress.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.0.0.0/8
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.1.0.0/16
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0]&#46;zoneIds[0]}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       isp: BGP
 *       addressName: ${name}
 *       netmode: public
 *       bandwidth: '1'
 *       securityProtectionTypes:
 *         - AntiDDoS_Enhanced
 *       paymentType: PayAsYouGo
 *   defaultImageCache:
 *     type: alicloud:eci:ImageCache
 *     name: default
 *     properties:
 *       imageCacheName: ${name}
 *       images:
 *         - registry-vpc.${defaultGetRegions.regions[0].id}.aliyuncs.com/eci_open/nginx:alpine
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       vswitchId: ${defaultSwitch.id}
 *       eipInstanceId: ${defaultEipAddress.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eci:getZones
 *       Arguments: {}
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECI Image Cache can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eci/imageCache:ImageCache example abc123456
 * ```
 * @property eipInstanceId The instance ID of the Elastic IP Address (EIP). If you want to pull images from the Internet, you must specify an EIP to make sure that the container group can access the Internet. You can also configure the network address translation (NAT) gateway. We recommend that you configure the NAT gateway for the Internet access. Refer to [Public Network Access Method](https://help.aliyun.com/document_detail/99146.html)
 * @property imageCacheName The name of the image cache.
 * @property imageCacheSize The size of the image cache. Default to `20`. Unit: GiB.
 * @property imageRegistryCredentials The Image Registry parameters about the image to be cached. See `image_registry_credential` below.
 * @property images The images to be cached. The image name must be versioned.
 * @property resourceGroupId The ID of the resource group.
 * @property retentionDays The retention days of the image cache. Once the image cache expires, it will be cleared. By default, the image cache never expires. Note: The image cache that fails to be created is retained for only one day.
 * @property securityGroupId The ID of the security group. You do not need to specify the same security group as the container group.
 * @property vswitchId The ID of the VSwitch. You do not need to specify the same VSwitch as the container group.
 * @property zoneId The zone id to cache image.
 */
public data class ImageCacheArgs(
    public val eipInstanceId: Output<String>? = null,
    public val imageCacheName: Output<String>? = null,
    public val imageCacheSize: Output<Int>? = null,
    public val imageRegistryCredentials: Output<List<ImageCacheImageRegistryCredentialArgs>>? = null,
    public val images: Output<List<String>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val retentionDays: Output<Int>? = null,
    public val securityGroupId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.ImageCacheArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.ImageCacheArgs =
        com.pulumi.alicloud.eci.ImageCacheArgs.builder()
            .eipInstanceId(eipInstanceId?.applyValue({ args0 -> args0 }))
            .imageCacheName(imageCacheName?.applyValue({ args0 -> args0 }))
            .imageCacheSize(imageCacheSize?.applyValue({ args0 -> args0 }))
            .imageRegistryCredentials(
                imageRegistryCredentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .images(images?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageCacheArgs].
 */
@PulumiTagMarker
public class ImageCacheArgsBuilder internal constructor() {
    private var eipInstanceId: Output<String>? = null

    private var imageCacheName: Output<String>? = null

    private var imageCacheSize: Output<Int>? = null

    private var imageRegistryCredentials: Output<List<ImageCacheImageRegistryCredentialArgs>>? = null

    private var images: Output<List<String>>? = null

    private var resourceGroupId: Output<String>? = null

    private var retentionDays: Output<Int>? = null

    private var securityGroupId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The instance ID of the Elastic IP Address (EIP). If you want to pull images from the Internet, you must specify an EIP to make sure that the container group can access the Internet. You can also configure the network address translation (NAT) gateway. We recommend that you configure the NAT gateway for the Internet access. Refer to [Public Network Access Method](https://help.aliyun.com/document_detail/99146.html)
     */
    @JvmName("sahkhojifrvgsecd")
    public suspend fun eipInstanceId(`value`: Output<String>) {
        this.eipInstanceId = value
    }

    /**
     * @param value The name of the image cache.
     */
    @JvmName("sylmmpravscemget")
    public suspend fun imageCacheName(`value`: Output<String>) {
        this.imageCacheName = value
    }

    /**
     * @param value The size of the image cache. Default to `20`. Unit: GiB.
     */
    @JvmName("otdryrkncdwssbgs")
    public suspend fun imageCacheSize(`value`: Output<Int>) {
        this.imageCacheSize = value
    }

    /**
     * @param value The Image Registry parameters about the image to be cached. See `image_registry_credential` below.
     */
    @JvmName("xdulgcttsfcbukfx")
    public suspend fun imageRegistryCredentials(`value`: Output<List<ImageCacheImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = value
    }

    @JvmName("vqyyyxcwvbscqedv")
    public suspend fun imageRegistryCredentials(vararg values: Output<ImageCacheImageRegistryCredentialArgs>) {
        this.imageRegistryCredentials = Output.all(values.asList())
    }

    /**
     * @param values The Image Registry parameters about the image to be cached. See `image_registry_credential` below.
     */
    @JvmName("mtkctkegnlvrgyqq")
    public suspend fun imageRegistryCredentials(values: List<Output<ImageCacheImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = Output.all(values)
    }

    /**
     * @param value The images to be cached. The image name must be versioned.
     */
    @JvmName("ltgkfsfqabqvupvl")
    public suspend fun images(`value`: Output<List<String>>) {
        this.images = value
    }

    @JvmName("pwkvpujlointfuvv")
    public suspend fun images(vararg values: Output<String>) {
        this.images = Output.all(values.asList())
    }

    /**
     * @param values The images to be cached. The image name must be versioned.
     */
    @JvmName("nbblyopximlejlsb")
    public suspend fun images(values: List<Output<String>>) {
        this.images = Output.all(values)
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("gllpsyfhqwrhtsam")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The retention days of the image cache. Once the image cache expires, it will be cleared. By default, the image cache never expires. Note: The image cache that fails to be created is retained for only one day.
     */
    @JvmName("uhhniubyhwehsmbh")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value The ID of the security group. You do not need to specify the same security group as the container group.
     */
    @JvmName("hrtpdxbocpeukmkj")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The ID of the VSwitch. You do not need to specify the same VSwitch as the container group.
     */
    @JvmName("mhdggbxixvnekvgx")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone id to cache image.
     */
    @JvmName("gwuqpuwiisgqgati")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The instance ID of the Elastic IP Address (EIP). If you want to pull images from the Internet, you must specify an EIP to make sure that the container group can access the Internet. You can also configure the network address translation (NAT) gateway. We recommend that you configure the NAT gateway for the Internet access. Refer to [Public Network Access Method](https://help.aliyun.com/document_detail/99146.html)
     */
    @JvmName("aliaamtoucqkmxpv")
    public suspend fun eipInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipInstanceId = mapped
    }

    /**
     * @param value The name of the image cache.
     */
    @JvmName("lgvseqlysxosqges")
    public suspend fun imageCacheName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageCacheName = mapped
    }

    /**
     * @param value The size of the image cache. Default to `20`. Unit: GiB.
     */
    @JvmName("duushysylcytnfpd")
    public suspend fun imageCacheSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageCacheSize = mapped
    }

    /**
     * @param value The Image Registry parameters about the image to be cached. See `image_registry_credential` below.
     */
    @JvmName("wlpqasjxbjyxqblj")
    public suspend fun imageRegistryCredentials(`value`: List<ImageCacheImageRegistryCredentialArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The Image Registry parameters about the image to be cached. See `image_registry_credential` below.
     */
    @JvmName("iwajrqnymqosvnxu")
    public suspend fun imageRegistryCredentials(argument: List<suspend ImageCacheImageRegistryCredentialArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageCacheImageRegistryCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The Image Registry parameters about the image to be cached. See `image_registry_credential` below.
     */
    @JvmName("gruwfeaogwcqeubm")
    public suspend fun imageRegistryCredentials(vararg argument: suspend ImageCacheImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageCacheImageRegistryCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The Image Registry parameters about the image to be cached. See `image_registry_credential` below.
     */
    @JvmName("easrccvnytlbevwf")
    public suspend fun imageRegistryCredentials(argument: suspend ImageCacheImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ImageCacheImageRegistryCredentialArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param values The Image Registry parameters about the image to be cached. See `image_registry_credential` below.
     */
    @JvmName("dbhgocwdtnovajmd")
    public suspend fun imageRegistryCredentials(vararg values: ImageCacheImageRegistryCredentialArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param value The images to be cached. The image name must be versioned.
     */
    @JvmName("bcddlvvviivpicof")
    public suspend fun images(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.images = mapped
    }

    /**
     * @param values The images to be cached. The image name must be versioned.
     */
    @JvmName("hvpwneswklhlqkis")
    public suspend fun images(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.images = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("lbfsxgbeehwfgyol")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The retention days of the image cache. Once the image cache expires, it will be cleared. By default, the image cache never expires. Note: The image cache that fails to be created is retained for only one day.
     */
    @JvmName("ivdresiggcwbwbja")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value The ID of the security group. You do not need to specify the same security group as the container group.
     */
    @JvmName("retyfptytcnlajnh")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The ID of the VSwitch. You do not need to specify the same VSwitch as the container group.
     */
    @JvmName("dncogcpmvomshubp")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone id to cache image.
     */
    @JvmName("sbniriuwidavuimp")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ImageCacheArgs = ImageCacheArgs(
        eipInstanceId = eipInstanceId,
        imageCacheName = imageCacheName,
        imageCacheSize = imageCacheSize,
        imageRegistryCredentials = imageRegistryCredentials,
        images = images,
        resourceGroupId = resourceGroupId,
        retentionDays = retentionDays,
        securityGroupId = securityGroupId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
