@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin

import com.pulumi.alicloud.eci.kotlin.outputs.OpenApiImageCacheImageRegistryCredential
import com.pulumi.alicloud.eci.kotlin.outputs.OpenApiImageCacheImageRegistryCredential.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [OpenApiImageCache].
 */
@PulumiTagMarker
public class OpenApiImageCacheResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OpenApiImageCacheArgs = OpenApiImageCacheArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OpenApiImageCacheArgsBuilder.() -> Unit) {
        val builder = OpenApiImageCacheArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OpenApiImageCache {
        val builtJavaResource = com.pulumi.alicloud.eci.OpenApiImageCache(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OpenApiImageCache(builtJavaResource)
    }
}

public class OpenApiImageCache internal constructor(
    override val javaResource: com.pulumi.alicloud.eci.OpenApiImageCache,
) : KotlinCustomResource(javaResource, OpenApiImageCacheMapper) {
    public val containerGroupId: Output<String>
        get() = javaResource.containerGroupId().applyValue({ args0 -> args0 })

    public val eipInstanceId: Output<String>?
        get() = javaResource.eipInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val imageCacheName: Output<String>
        get() = javaResource.imageCacheName().applyValue({ args0 -> args0 })

    public val imageCacheSize: Output<Int>?
        get() = javaResource.imageCacheSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val imageRegistryCredentials: Output<List<OpenApiImageCacheImageRegistryCredential>>?
        get() = javaResource.imageRegistryCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    public val images: Output<List<String>>
        get() = javaResource.images().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val retentionDays: Output<Int>?
        get() = javaResource.retentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    public val zoneId: Output<String>?
        get() = javaResource.zoneId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object OpenApiImageCacheMapper : ResourceMapper<OpenApiImageCache> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.eci.OpenApiImageCache::class == javaResource::class

    override fun map(javaResource: Resource): OpenApiImageCache = OpenApiImageCache(
        javaResource as
            com.pulumi.alicloud.eci.OpenApiImageCache,
    )
}

/**
 * @see [OpenApiImageCache].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OpenApiImageCache].
 */
public suspend fun openApiImageCache(
    name: String,
    block: suspend OpenApiImageCacheResourceBuilder.() -> Unit,
): OpenApiImageCache {
    val builder = OpenApiImageCacheResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OpenApiImageCache].
 * @param name The _unique_ name of the resulting resource.
 */
public fun openApiImageCache(name: String): OpenApiImageCache {
    val builder = OpenApiImageCacheResourceBuilder()
    builder.name(name)
    return builder.build()
}
