@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin

import com.pulumi.alicloud.eci.OpenApiImageCacheArgs.builder
import com.pulumi.alicloud.eci.kotlin.inputs.OpenApiImageCacheImageRegistryCredentialArgs
import com.pulumi.alicloud.eci.kotlin.inputs.OpenApiImageCacheImageRegistryCredentialArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property eipInstanceId
 * @property imageCacheName
 * @property imageCacheSize
 * @property imageRegistryCredentials
 * @property images
 * @property resourceGroupId
 * @property retentionDays
 * @property securityGroupId
 * @property vswitchId
 * @property zoneId
 */
public data class OpenApiImageCacheArgs(
    public val eipInstanceId: Output<String>? = null,
    public val imageCacheName: Output<String>? = null,
    public val imageCacheSize: Output<Int>? = null,
    public val imageRegistryCredentials: Output<List<OpenApiImageCacheImageRegistryCredentialArgs>>? =
        null,
    public val images: Output<List<String>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val retentionDays: Output<Int>? = null,
    public val securityGroupId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.OpenApiImageCacheArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.OpenApiImageCacheArgs =
        com.pulumi.alicloud.eci.OpenApiImageCacheArgs.builder()
            .eipInstanceId(eipInstanceId?.applyValue({ args0 -> args0 }))
            .imageCacheName(imageCacheName?.applyValue({ args0 -> args0 }))
            .imageCacheSize(imageCacheSize?.applyValue({ args0 -> args0 }))
            .imageRegistryCredentials(
                imageRegistryCredentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .images(images?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenApiImageCacheArgs].
 */
@PulumiTagMarker
public class OpenApiImageCacheArgsBuilder internal constructor() {
    private var eipInstanceId: Output<String>? = null

    private var imageCacheName: Output<String>? = null

    private var imageCacheSize: Output<Int>? = null

    private var imageRegistryCredentials: Output<List<OpenApiImageCacheImageRegistryCredentialArgs>>? =
        null

    private var images: Output<List<String>>? = null

    private var resourceGroupId: Output<String>? = null

    private var retentionDays: Output<Int>? = null

    private var securityGroupId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("hyhanyvrawhyhadv")
    public suspend fun eipInstanceId(`value`: Output<String>) {
        this.eipInstanceId = value
    }

    /**
     * @param value
     */
    @JvmName("wlibxulnqomownee")
    public suspend fun imageCacheName(`value`: Output<String>) {
        this.imageCacheName = value
    }

    /**
     * @param value
     */
    @JvmName("wimpfjfrpgdxbasv")
    public suspend fun imageCacheSize(`value`: Output<Int>) {
        this.imageCacheSize = value
    }

    /**
     * @param value
     */
    @JvmName("irkaximecwoglnrs")
    public suspend fun imageRegistryCredentials(`value`: Output<List<OpenApiImageCacheImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = value
    }

    @JvmName("cktaxmlijuathlxh")
    public suspend fun imageRegistryCredentials(vararg values: Output<OpenApiImageCacheImageRegistryCredentialArgs>) {
        this.imageRegistryCredentials = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ootqohlebqiglhdl")
    public suspend fun imageRegistryCredentials(values: List<Output<OpenApiImageCacheImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("evafmtvsfoqfcara")
    public suspend fun images(`value`: Output<List<String>>) {
        this.images = value
    }

    @JvmName("qdrwljnauwkpcosb")
    public suspend fun images(vararg values: Output<String>) {
        this.images = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rkejlflehpegxnvt")
    public suspend fun images(values: List<Output<String>>) {
        this.images = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("yhsqkkmlgbqbvgmr")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("dtwrkdsejelvopnc")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value
     */
    @JvmName("hleklbrduukjxhnr")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("kmoirigidflqlltn")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value
     */
    @JvmName("xfydyxmpeqoebbpu")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value
     */
    @JvmName("vpfglkvjkgnmfrta")
    public suspend fun eipInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipInstanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("sxgfeyhhpeollxgh")
    public suspend fun imageCacheName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageCacheName = mapped
    }

    /**
     * @param value
     */
    @JvmName("hslnuxhqiemoqlca")
    public suspend fun imageCacheSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageCacheSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("cyttrkufumkkoicw")
    public suspend fun imageRegistryCredentials(`value`: List<OpenApiImageCacheImageRegistryCredentialArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fitttqjiwcbpclyl")
    public suspend fun imageRegistryCredentials(argument: List<suspend OpenApiImageCacheImageRegistryCredentialArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenApiImageCacheImageRegistryCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument
     */
    @JvmName("odhbfkajebmoduwy")
    public suspend fun imageRegistryCredentials(vararg argument: suspend OpenApiImageCacheImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OpenApiImageCacheImageRegistryCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bvnrtjhmdtqmeujx")
    public suspend fun imageRegistryCredentials(argument: suspend OpenApiImageCacheImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OpenApiImageCacheImageRegistryCredentialArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param values
     */
    @JvmName("roqvhypyftuednbl")
    public suspend fun imageRegistryCredentials(vararg values: OpenApiImageCacheImageRegistryCredentialArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param value
     */
    @JvmName("iqjpxfudalprkrja")
    public suspend fun images(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.images = mapped
    }

    /**
     * @param values
     */
    @JvmName("nlsacjutrtnhovnm")
    public suspend fun images(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.images = mapped
    }

    /**
     * @param value
     */
    @JvmName("nywfewhexrrqrayg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("dyfpbykyowpabblg")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value
     */
    @JvmName("kjyxknknfgywunqp")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("yaqevfdfkgbwitkb")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value
     */
    @JvmName("obynxoqubpoqrsko")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): OpenApiImageCacheArgs = OpenApiImageCacheArgs(
        eipInstanceId = eipInstanceId,
        imageCacheName = imageCacheName,
        imageCacheSize = imageCacheSize,
        imageRegistryCredentials = imageRegistryCredentials,
        images = images,
        resourceGroupId = resourceGroupId,
        retentionDays = retentionDays,
        securityGroupId = securityGroupId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
