@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin

import com.pulumi.alicloud.eci.VirtualNodeArgs.builder
import com.pulumi.alicloud.eci.kotlin.inputs.VirtualNodeTaintArgs
import com.pulumi.alicloud.eci.kotlin.inputs.VirtualNodeTaintArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ECI Virtual Node resource.
 * For information about ECI Virtual Node and how to use it, see [What is Virtual Node](https://www.alibabacloud.com/help/en/doc-detail/89129.html).
 * > **NOTE:** Available since v1.145.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.eci.getZones({});
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.1.0.0/16",
 *     vpcId: defaultNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?&#46;zoneIds?&#46;[0]),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: name,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {
 *     isp: "BGP",
 *     addressName: name,
 *     netmode: "public",
 *     bandwidth: "1",
 *     securityProtectionTypes: ["AntiDDoS_Enhanced"],
 *     paymentType: "PayAsYouGo",
 * });
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({});
 * const defaultVirtualNode = new alicloud.eci.VirtualNode("default", {
 *     securityGroupId: defaultSecurityGroup.id,
 *     virtualNodeName: name,
 *     vswitchId: defaultSwitch.id,
 *     enablePublicNetwork: false,
 *     eipInstanceId: defaultEipAddress.id,
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.groups?.[0]?.id),
 *     kubeConfig: "kube_config",
 *     tags: {
 *         Created: "TF",
 *     },
 *     taints: [{
 *         effect: "NoSchedule",
 *         key: "TF",
 *         value: "example",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.eci.get_zones()
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.0.0.0/8")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.1.0.0/16",
 *     vpc_id=default_network.id,
 *     zone_id=default.zones[0]&#46;zone_ids[0])
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=name,
 *     vpc_id=default_network.id)
 * default_eip_address = alicloud.ecs.EipAddress("default",
 *     isp="BGP",
 *     address_name=name,
 *     netmode="public",
 *     bandwidth="1",
 *     security_protection_types=["AntiDDoS_Enhanced"],
 *     payment_type="PayAsYouGo")
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
 * default_virtual_node = alicloud.eci.VirtualNode("default",
 *     security_group_id=default_security_group.id,
 *     virtual_node_name=name,
 *     vswitch_id=default_switch.id,
 *     enable_public_network=False,
 *     eip_instance_id=default_eip_address.id,
 *     resource_group_id=default_get_resource_groups.groups[0].id,
 *     kube_config="kube_config",
 *     tags={
 *         "Created": "TF",
 *     },
 *     taints=[{
 *         "effect": "NoSchedule",
 *         "key": "TF",
 *         "value": "example",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.Eci.GetZones.Invoke();
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.1.0.0/16",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?&#46;ZoneIds[0])),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = name,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         Isp = "BGP",
 *         AddressName = name,
 *         Netmode = "public",
 *         Bandwidth = "1",
 *         SecurityProtectionTypes = new[]
 *         {
 *             "AntiDDoS_Enhanced",
 *         },
 *         PaymentType = "PayAsYouGo",
 *     });
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultVirtualNode = new AliCloud.Eci.VirtualNode("default", new()
 *     {
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         VirtualNodeName = name,
 *         VswitchId = defaultSwitch.Id,
 *         EnablePublicNetwork = false,
 *         EipInstanceId = defaultEipAddress.Id,
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id),
 *         KubeConfig = "kube_config",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *         },
 *         Taints = new[]
 *         {
 *             new AliCloud.Eci.Inputs.VirtualNodeTaintArgs
 *             {
 *                 Effect = "NoSchedule",
 *                 Key = "TF",
 *                 Value = "example",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/eci"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := eci.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.1.0.0/16"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0]&#46;ZoneIds[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			Isp:         pulumi.String("BGP"),
 * 			AddressName: pulumi.String(name),
 * 			Netmode:     pulumi.String("public"),
 * 			Bandwidth:   pulumi.String("1"),
 * 			SecurityProtectionTypes: pulumi.StringArray{
 * 				pulumi.String("AntiDDoS_Enhanced"),
 * 			},
 * 			PaymentType: pulumi.String("PayAsYouGo"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = eci.NewVirtualNode(ctx, "default", &eci.VirtualNodeArgs{
 * 			SecurityGroupId:     defaultSecurityGroup.ID(),
 * 			VirtualNodeName:     pulumi.String(name),
 * 			VswitchId:           defaultSwitch.ID(),
 * 			EnablePublicNetwork: pulumi.Bool(false),
 * 			EipInstanceId:       defaultEipAddress.ID(),
 * 			ResourceGroupId:     pulumi.String(defaultGetResourceGroups.Groups[0].Id),
 * 			KubeConfig:          pulumi.String("kube_config"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 			},
 * 			Taints: eci.VirtualNodeTaintArray{
 * 				&eci.VirtualNodeTaintArgs{
 * 					Effect: pulumi.String("NoSchedule"),
 * 					Key:    pulumi.String("TF"),
 * 					Value:  pulumi.String("example"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.eci.EciFunctions;
 * import com.pulumi.alicloud.eci.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.eci.VirtualNode;
 * import com.pulumi.alicloud.eci.VirtualNodeArgs;
 * import com.pulumi.alicloud.eci.inputs.VirtualNodeTaintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = EciFunctions.getZones();
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.1.0.0/16")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(default_.zones()[0]&#46;zoneIds()[0])
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultEipAddress = new EipAddress("defaultEipAddress", EipAddressArgs.builder()
 *             .isp("BGP")
 *             .addressName(name)
 *             .netmode("public")
 *             .bandwidth("1")
 *             .securityProtectionTypes("AntiDDoS_Enhanced")
 *             .paymentType("PayAsYouGo")
 *             .build());
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultVirtualNode = new VirtualNode("defaultVirtualNode", VirtualNodeArgs.builder()
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .virtualNodeName(name)
 *             .vswitchId(defaultSwitch.id())
 *             .enablePublicNetwork(false)
 *             .eipInstanceId(defaultEipAddress.id())
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.groups()[0].id()))
 *             .kubeConfig("kube_config")
 *             .tags(Map.of("Created", "TF"))
 *             .taints(VirtualNodeTaintArgs.builder()
 *                 .effect("NoSchedule")
 *                 .key("TF")
 *                 .value("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.0.0.0/8
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.1.0.0/16
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${default.zones[0]&#46;zoneIds[0]}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultNetwork.id}
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       isp: BGP
 *       addressName: ${name}
 *       netmode: public
 *       bandwidth: '1'
 *       securityProtectionTypes:
 *         - AntiDDoS_Enhanced
 *       paymentType: PayAsYouGo
 *   defaultVirtualNode:
 *     type: alicloud:eci:VirtualNode
 *     name: default
 *     properties:
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       virtualNodeName: ${name}
 *       vswitchId: ${defaultSwitch.id}
 *       enablePublicNetwork: false
 *       eipInstanceId: ${defaultEipAddress.id}
 *       resourceGroupId: ${defaultGetResourceGroups.groups[0].id}
 *       kubeConfig: kube_config
 *       tags:
 *         Created: TF
 *       taints:
 *         - effect: NoSchedule
 *           key: TF
 *           value: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:eci:getZones
 *       Arguments: {}
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ECI Virtual Node can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:eci/virtualNode:VirtualNode example <id>
 * ```
 * @property eipInstanceId The Id of eip.
 * @property enablePublicNetwork Whether to enable public network. **NOTE:** If `eip_instance_id` is not configured and `enable_public_network` is true, the system will create an elastic public network IP.
 * @property kubeConfig The kube config for the k8s cluster. It needs to be connected after Base64 encoding.
 * @property resourceGroupId The resource group ID.
 * @property securityGroupId The security group ID.
 * @property tags A mapping of tags to assign to the resource.
 * @property taints The taint. See `taints` below.
 * @property virtualNodeName The name of the virtual node. The length of the name is limited to `2` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, half-width colon (:), underscores (_), or hyphens (-), and must start with letters.
 * @property vswitchId The vswitch id.
 * @property zoneId The Zone.
 */
public data class VirtualNodeArgs(
    public val eipInstanceId: Output<String>? = null,
    public val enablePublicNetwork: Output<Boolean>? = null,
    public val kubeConfig: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taints: Output<List<VirtualNodeTaintArgs>>? = null,
    public val virtualNodeName: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.VirtualNodeArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.VirtualNodeArgs =
        com.pulumi.alicloud.eci.VirtualNodeArgs.builder()
            .eipInstanceId(eipInstanceId?.applyValue({ args0 -> args0 }))
            .enablePublicNetwork(enablePublicNetwork?.applyValue({ args0 -> args0 }))
            .kubeConfig(kubeConfig?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taints(taints?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .virtualNodeName(virtualNodeName?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeArgs].
 */
@PulumiTagMarker
public class VirtualNodeArgsBuilder internal constructor() {
    private var eipInstanceId: Output<String>? = null

    private var enablePublicNetwork: Output<Boolean>? = null

    private var kubeConfig: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taints: Output<List<VirtualNodeTaintArgs>>? = null

    private var virtualNodeName: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The Id of eip.
     */
    @JvmName("hwfccexjhsksvuif")
    public suspend fun eipInstanceId(`value`: Output<String>) {
        this.eipInstanceId = value
    }

    /**
     * @param value Whether to enable public network. **NOTE:** If `eip_instance_id` is not configured and `enable_public_network` is true, the system will create an elastic public network IP.
     */
    @JvmName("yufgtuepojforjpt")
    public suspend fun enablePublicNetwork(`value`: Output<Boolean>) {
        this.enablePublicNetwork = value
    }

    /**
     * @param value The kube config for the k8s cluster. It needs to be connected after Base64 encoding.
     */
    @JvmName("ybqkeyphpfwtoqqx")
    public suspend fun kubeConfig(`value`: Output<String>) {
        this.kubeConfig = value
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("lvdpcdfjwhhrycqk")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The security group ID.
     */
    @JvmName("jfhpehttxjdqtcpt")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("rpbgxbhydyuagoop")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The taint. See `taints` below.
     */
    @JvmName("nqmunucjehjgusgw")
    public suspend fun taints(`value`: Output<List<VirtualNodeTaintArgs>>) {
        this.taints = value
    }

    @JvmName("dgfrhafichkvxfsf")
    public suspend fun taints(vararg values: Output<VirtualNodeTaintArgs>) {
        this.taints = Output.all(values.asList())
    }

    /**
     * @param values The taint. See `taints` below.
     */
    @JvmName("ylohlbkvjguvlvse")
    public suspend fun taints(values: List<Output<VirtualNodeTaintArgs>>) {
        this.taints = Output.all(values)
    }

    /**
     * @param value The name of the virtual node. The length of the name is limited to `2` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, half-width colon (:), underscores (_), or hyphens (-), and must start with letters.
     */
    @JvmName("mdfqmtthauhdwhwe")
    public suspend fun virtualNodeName(`value`: Output<String>) {
        this.virtualNodeName = value
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("vpcocgldgmkfmvaa")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone.
     */
    @JvmName("ipbyvaigtrayaukf")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The Id of eip.
     */
    @JvmName("ricepywlhenswwfi")
    public suspend fun eipInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipInstanceId = mapped
    }

    /**
     * @param value Whether to enable public network. **NOTE:** If `eip_instance_id` is not configured and `enable_public_network` is true, the system will create an elastic public network IP.
     */
    @JvmName("qneevwqjtgvycssn")
    public suspend fun enablePublicNetwork(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePublicNetwork = mapped
    }

    /**
     * @param value The kube config for the k8s cluster. It needs to be connected after Base64 encoding.
     */
    @JvmName("kqfhvieyhcdnkchx")
    public suspend fun kubeConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeConfig = mapped
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("rhutdmqgnpulbbfo")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The security group ID.
     */
    @JvmName("gqulikkdliiaqtua")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("nduktakyrfvxfubl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("wkwgmeohpmwbwjcg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The taint. See `taints` below.
     */
    @JvmName("ecbqyvsdwetgbuir")
    public suspend fun taints(`value`: List<VirtualNodeTaintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param argument The taint. See `taints` below.
     */
    @JvmName("xadctwcddpacmxkw")
    public suspend fun taints(argument: List<suspend VirtualNodeTaintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNodeTaintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument The taint. See `taints` below.
     */
    @JvmName("mriexakbsaajnpqy")
    public suspend fun taints(vararg argument: suspend VirtualNodeTaintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNodeTaintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument The taint. See `taints` below.
     */
    @JvmName("vkhykltikisuufur")
    public suspend fun taints(argument: suspend VirtualNodeTaintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNodeTaintArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param values The taint. See `taints` below.
     */
    @JvmName("nwnlbtbvvqucquwk")
    public suspend fun taints(vararg values: VirtualNodeTaintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param value The name of the virtual node. The length of the name is limited to `2` to `128` characters. It can contain uppercase and lowercase letters, Chinese characters, numbers, half-width colon (:), underscores (_), or hyphens (-), and must start with letters.
     */
    @JvmName("xohlbkcypietatng")
    public suspend fun virtualNodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNodeName = mapped
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("fdisxviovpnjkktc")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone.
     */
    @JvmName("fhamkjgoplhcvrjp")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): VirtualNodeArgs = VirtualNodeArgs(
        eipInstanceId = eipInstanceId,
        enablePublicNetwork = enablePublicNetwork,
        kubeConfig = kubeConfig,
        resourceGroupId = resourceGroupId,
        securityGroupId = securityGroupId,
        tags = tags,
        taints = taints,
        virtualNodeName = virtualNodeName,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
