@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupAcrRegistryInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property domains The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
 * @property instanceId The ACR enterprise edition example ID.
 * @property instanceName The name of the ACR enterprise edition instance.
 * @property regionId The ACR enterprise edition instance belongs to the region.
 */
public data class ContainerGroupAcrRegistryInfoArgs(
    public val domains: Output<List<String>>? = null,
    public val instanceId: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val regionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupAcrRegistryInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupAcrRegistryInfoArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupAcrRegistryInfoArgs.builder()
            .domains(domains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .regionId(regionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupAcrRegistryInfoArgs].
 */
@PulumiTagMarker
public class ContainerGroupAcrRegistryInfoArgsBuilder internal constructor() {
    private var domains: Output<List<String>>? = null

    private var instanceId: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var regionId: Output<String>? = null

    /**
     * @param value The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
     */
    @JvmName("gdfeqoawnavotoed")
    public suspend fun domains(`value`: Output<List<String>>) {
        this.domains = value
    }

    @JvmName("mktsicdqautvljbc")
    public suspend fun domains(vararg values: Output<String>) {
        this.domains = Output.all(values.asList())
    }

    /**
     * @param values The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
     */
    @JvmName("nqviwbpooglleruq")
    public suspend fun domains(values: List<Output<String>>) {
        this.domains = Output.all(values)
    }

    /**
     * @param value The ACR enterprise edition example ID.
     */
    @JvmName("rtcfsmxtkpurtbhh")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of the ACR enterprise edition instance.
     */
    @JvmName("uwgxsrevkoglmwxh")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The ACR enterprise edition instance belongs to the region.
     */
    @JvmName("nrnescyiccwygfay")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
     */
    @JvmName("oyrtbqlqiqpseodd")
    public suspend fun domains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param values The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
     */
    @JvmName("gjnuptwgxfwgirnk")
    public suspend fun domains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param value The ACR enterprise edition example ID.
     */
    @JvmName("plsakuhcphdeutrs")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the ACR enterprise edition instance.
     */
    @JvmName("lfivvrciqmdivrcr")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The ACR enterprise edition instance belongs to the region.
     */
    @JvmName("lqcolnupkamljpuj")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    internal fun build(): ContainerGroupAcrRegistryInfoArgs = ContainerGroupAcrRegistryInfoArgs(
        domains = domains,
        instanceId = instanceId,
        instanceName = instanceName,
        regionId = regionId,
    )
}
