@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property args The arguments passed to the commands.
 * @property commands Commands to be executed inside the container when performing health checks using the command line method.
 * @property cpu The amount of CPU resources allocated to the container. Default value: `0`.
 * @property environmentVars The structure of environmentVars. See `environment_vars` below.
 * @property gpu The number GPUs. Default value: `0`.
 * @property image The image of the container.
 * @property imagePullPolicy The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
 * @property lifecyclePreStopHandlerExecs The commands to be executed in containers when you use the CLI to specify the preStop callback function.
 * @property livenessProbes The health check of the container. See `liveness_probe` below.
 * @property memory The amount of memory resources allocated to the container. Default value: `0`.
 * @property name The name of the mounted volume.
 * @property ports The structure of port. See `ports` below.
 * @property readinessProbes The health check of the container. See `readiness_probe` below.
 * @property ready Indicates whether the container passed the readiness probe.
 * @property restartCount The number of times that the container restarted.
 * @property securityContexts The security context of the container. See `security_context` below.
 * @property volumeMounts The structure of volumeMounts. See `volume_mounts` below.
 * @property workingDir The working directory of the container.
 */
public data class ContainerGroupContainerArgs(
    public val args: Output<List<String>>? = null,
    public val commands: Output<List<String>>? = null,
    public val cpu: Output<Double>? = null,
    public val environmentVars: Output<List<ContainerGroupContainerEnvironmentVarArgs>>? = null,
    public val gpu: Output<Int>? = null,
    public val image: Output<String>,
    public val imagePullPolicy: Output<String>? = null,
    public val lifecyclePreStopHandlerExecs: Output<List<String>>? = null,
    public val livenessProbes: Output<List<ContainerGroupContainerLivenessProbeArgs>>? = null,
    public val memory: Output<Double>? = null,
    public val name: Output<String>,
    public val ports: Output<List<ContainerGroupContainerPortArgs>>? = null,
    public val readinessProbes: Output<List<ContainerGroupContainerReadinessProbeArgs>>? = null,
    public val ready: Output<Boolean>? = null,
    public val restartCount: Output<Int>? = null,
    public val securityContexts: Output<List<ContainerGroupContainerSecurityContextArgs>>? = null,
    public val volumeMounts: Output<List<ContainerGroupContainerVolumeMountArgs>>? = null,
    public val workingDir: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupContainerArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupContainerArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupContainerArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .environmentVars(
                environmentVars?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gpu(gpu?.applyValue({ args0 -> args0 }))
            .image(image.applyValue({ args0 -> args0 }))
            .imagePullPolicy(imagePullPolicy?.applyValue({ args0 -> args0 }))
            .lifecyclePreStopHandlerExecs(
                lifecyclePreStopHandlerExecs?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .livenessProbes(
                livenessProbes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .memory(memory?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .readinessProbes(
                readinessProbes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ready(ready?.applyValue({ args0 -> args0 }))
            .restartCount(restartCount?.applyValue({ args0 -> args0 }))
            .securityContexts(
                securityContexts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .workingDir(workingDir?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupContainerArgs].
 */
@PulumiTagMarker
public class ContainerGroupContainerArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var commands: Output<List<String>>? = null

    private var cpu: Output<Double>? = null

    private var environmentVars: Output<List<ContainerGroupContainerEnvironmentVarArgs>>? = null

    private var gpu: Output<Int>? = null

    private var image: Output<String>? = null

    private var imagePullPolicy: Output<String>? = null

    private var lifecyclePreStopHandlerExecs: Output<List<String>>? = null

    private var livenessProbes: Output<List<ContainerGroupContainerLivenessProbeArgs>>? = null

    private var memory: Output<Double>? = null

    private var name: Output<String>? = null

    private var ports: Output<List<ContainerGroupContainerPortArgs>>? = null

    private var readinessProbes: Output<List<ContainerGroupContainerReadinessProbeArgs>>? = null

    private var ready: Output<Boolean>? = null

    private var restartCount: Output<Int>? = null

    private var securityContexts: Output<List<ContainerGroupContainerSecurityContextArgs>>? = null

    private var volumeMounts: Output<List<ContainerGroupContainerVolumeMountArgs>>? = null

    private var workingDir: Output<String>? = null

    /**
     * @param value The arguments passed to the commands.
     */
    @JvmName("orfynuhuhufdlolx")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("bqiftpsytgafwfus")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values The arguments passed to the commands.
     */
    @JvmName("qbsufajpacfhoffa")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Commands to be executed inside the container when performing health checks using the command line method.
     */
    @JvmName("xtutkyqxuxypepdv")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("dautxxwyijkdppdj")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values Commands to be executed inside the container when performing health checks using the command line method.
     */
    @JvmName("omtqiivyflpkuqcg")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value The amount of CPU resources allocated to the container. Default value: `0`.
     */
    @JvmName("eeigeahbkjljtsco")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("jynvamudiorrdvee")
    public suspend fun environmentVars(`value`: Output<List<ContainerGroupContainerEnvironmentVarArgs>>) {
        this.environmentVars = value
    }

    @JvmName("aspmolxurpobghjj")
    public suspend fun environmentVars(vararg values: Output<ContainerGroupContainerEnvironmentVarArgs>) {
        this.environmentVars = Output.all(values.asList())
    }

    /**
     * @param values The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("kxyovxfkdvhycycm")
    public suspend fun environmentVars(values: List<Output<ContainerGroupContainerEnvironmentVarArgs>>) {
        this.environmentVars = Output.all(values)
    }

    /**
     * @param value The number GPUs. Default value: `0`.
     */
    @JvmName("xhufnrprnntoteto")
    public suspend fun gpu(`value`: Output<Int>) {
        this.gpu = value
    }

    /**
     * @param value The image of the container.
     */
    @JvmName("eevlkyjlvcouynob")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
     */
    @JvmName("yvgkplmjqxbmsusa")
    public suspend fun imagePullPolicy(`value`: Output<String>) {
        this.imagePullPolicy = value
    }

    /**
     * @param value The commands to be executed in containers when you use the CLI to specify the preStop callback function.
     */
    @JvmName("hfouvejjttifseco")
    public suspend fun lifecyclePreStopHandlerExecs(`value`: Output<List<String>>) {
        this.lifecyclePreStopHandlerExecs = value
    }

    @JvmName("aqauwhcwmigajdew")
    public suspend fun lifecyclePreStopHandlerExecs(vararg values: Output<String>) {
        this.lifecyclePreStopHandlerExecs = Output.all(values.asList())
    }

    /**
     * @param values The commands to be executed in containers when you use the CLI to specify the preStop callback function.
     */
    @JvmName("rrwynejdsjxttdad")
    public suspend fun lifecyclePreStopHandlerExecs(values: List<Output<String>>) {
        this.lifecyclePreStopHandlerExecs = Output.all(values)
    }

    /**
     * @param value The health check of the container. See `liveness_probe` below.
     */
    @JvmName("kekhgvroylrunxew")
    public suspend fun livenessProbes(`value`: Output<List<ContainerGroupContainerLivenessProbeArgs>>) {
        this.livenessProbes = value
    }

    @JvmName("qmvphmuefdthxjnc")
    public suspend fun livenessProbes(vararg values: Output<ContainerGroupContainerLivenessProbeArgs>) {
        this.livenessProbes = Output.all(values.asList())
    }

    /**
     * @param values The health check of the container. See `liveness_probe` below.
     */
    @JvmName("yodwgmcqdrvcrwxy")
    public suspend fun livenessProbes(values: List<Output<ContainerGroupContainerLivenessProbeArgs>>) {
        this.livenessProbes = Output.all(values)
    }

    /**
     * @param value The amount of memory resources allocated to the container. Default value: `0`.
     */
    @JvmName("qtlqrljsbudseghh")
    public suspend fun memory(`value`: Output<Double>) {
        this.memory = value
    }

    /**
     * @param value The name of the mounted volume.
     */
    @JvmName("qepdgjvvfqjmwtbq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The structure of port. See `ports` below.
     */
    @JvmName("toojarnqswlwqnas")
    public suspend fun ports(`value`: Output<List<ContainerGroupContainerPortArgs>>) {
        this.ports = value
    }

    @JvmName("aqfrwqvdllokgnrk")
    public suspend fun ports(vararg values: Output<ContainerGroupContainerPortArgs>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values The structure of port. See `ports` below.
     */
    @JvmName("majkdvotpybwxpwa")
    public suspend fun ports(values: List<Output<ContainerGroupContainerPortArgs>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value The health check of the container. See `readiness_probe` below.
     */
    @JvmName("ydlpbuqcpecgenek")
    public suspend fun readinessProbes(`value`: Output<List<ContainerGroupContainerReadinessProbeArgs>>) {
        this.readinessProbes = value
    }

    @JvmName("hpuvpmaopyhxaboc")
    public suspend fun readinessProbes(vararg values: Output<ContainerGroupContainerReadinessProbeArgs>) {
        this.readinessProbes = Output.all(values.asList())
    }

    /**
     * @param values The health check of the container. See `readiness_probe` below.
     */
    @JvmName("vsiuobrtuuibrcif")
    public suspend fun readinessProbes(values: List<Output<ContainerGroupContainerReadinessProbeArgs>>) {
        this.readinessProbes = Output.all(values)
    }

    /**
     * @param value Indicates whether the container passed the readiness probe.
     */
    @JvmName("waxhckeevnnxpyps")
    public suspend fun ready(`value`: Output<Boolean>) {
        this.ready = value
    }

    /**
     * @param value The number of times that the container restarted.
     */
    @JvmName("imliggvhkottridj")
    public suspend fun restartCount(`value`: Output<Int>) {
        this.restartCount = value
    }

    /**
     * @param value The security context of the container. See `security_context` below.
     */
    @JvmName("qigjthhelpidsdbg")
    public suspend fun securityContexts(`value`: Output<List<ContainerGroupContainerSecurityContextArgs>>) {
        this.securityContexts = value
    }

    @JvmName("gvntilbmepfvikki")
    public suspend fun securityContexts(vararg values: Output<ContainerGroupContainerSecurityContextArgs>) {
        this.securityContexts = Output.all(values.asList())
    }

    /**
     * @param values The security context of the container. See `security_context` below.
     */
    @JvmName("efxgdmtrmnuntohp")
    public suspend fun securityContexts(values: List<Output<ContainerGroupContainerSecurityContextArgs>>) {
        this.securityContexts = Output.all(values)
    }

    /**
     * @param value The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("uonvelxskvnkxnrx")
    public suspend fun volumeMounts(`value`: Output<List<ContainerGroupContainerVolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("klcbslqcuktoqstn")
    public suspend fun volumeMounts(vararg values: Output<ContainerGroupContainerVolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("aaachsdmhdxguiro")
    public suspend fun volumeMounts(values: List<Output<ContainerGroupContainerVolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value The working directory of the container.
     */
    @JvmName("jaqqlbfegnafjpmr")
    public suspend fun workingDir(`value`: Output<String>) {
        this.workingDir = value
    }

    /**
     * @param value The arguments passed to the commands.
     */
    @JvmName("hkenwoqugqsyfccc")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values The arguments passed to the commands.
     */
    @JvmName("hdvyrtkswopkaasg")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Commands to be executed inside the container when performing health checks using the command line method.
     */
    @JvmName("wkbythqjsaqvlaqa")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values Commands to be executed inside the container when performing health checks using the command line method.
     */
    @JvmName("gwvmkdbyowbmnfoj")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value The amount of CPU resources allocated to the container. Default value: `0`.
     */
    @JvmName("oxxidqfccvfxyuyc")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("mtigwipuddmlahtm")
    public suspend fun environmentVars(`value`: List<ContainerGroupContainerEnvironmentVarArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("mdtqophtsfcdhbky")
    public suspend fun environmentVars(argument: List<suspend ContainerGroupContainerEnvironmentVarArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerEnvironmentVarArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("yxvnvlpepasklthn")
    public suspend fun environmentVars(vararg argument: suspend ContainerGroupContainerEnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerEnvironmentVarArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("tlbxildmfvmxntte")
    public suspend fun environmentVars(argument: suspend ContainerGroupContainerEnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerEnvironmentVarArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param values The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("oysyrrgwykfceiyi")
    public suspend fun environmentVars(vararg values: ContainerGroupContainerEnvironmentVarArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVars = mapped
    }

    /**
     * @param value The number GPUs. Default value: `0`.
     */
    @JvmName("tohdwpjdoaqkrgnx")
    public suspend fun gpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpu = mapped
    }

    /**
     * @param value The image of the container.
     */
    @JvmName("lmbxlgdvajlueqfk")
    public suspend fun image(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
     */
    @JvmName("dwevkbypvdmkvomb")
    public suspend fun imagePullPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePullPolicy = mapped
    }

    /**
     * @param value The commands to be executed in containers when you use the CLI to specify the preStop callback function.
     */
    @JvmName("yrigdtetinhvafvl")
    public suspend fun lifecyclePreStopHandlerExecs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecyclePreStopHandlerExecs = mapped
    }

    /**
     * @param values The commands to be executed in containers when you use the CLI to specify the preStop callback function.
     */
    @JvmName("groxhktbyqxgpjby")
    public suspend fun lifecyclePreStopHandlerExecs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecyclePreStopHandlerExecs = mapped
    }

    /**
     * @param value The health check of the container. See `liveness_probe` below.
     */
    @JvmName("vhhvfkudcenkogwx")
    public suspend fun livenessProbes(`value`: List<ContainerGroupContainerLivenessProbeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbes = mapped
    }

    /**
     * @param argument The health check of the container. See `liveness_probe` below.
     */
    @JvmName("qlhdgqlrbiauslwl")
    public suspend fun livenessProbes(argument: List<suspend ContainerGroupContainerLivenessProbeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerLivenessProbeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.livenessProbes = mapped
    }

    /**
     * @param argument The health check of the container. See `liveness_probe` below.
     */
    @JvmName("jqaaglxdqftafeac")
    public suspend fun livenessProbes(vararg argument: suspend ContainerGroupContainerLivenessProbeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerLivenessProbeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.livenessProbes = mapped
    }

    /**
     * @param argument The health check of the container. See `liveness_probe` below.
     */
    @JvmName("mrhhqlwstkgvqqnp")
    public suspend fun livenessProbes(argument: suspend ContainerGroupContainerLivenessProbeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerLivenessProbeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.livenessProbes = mapped
    }

    /**
     * @param values The health check of the container. See `liveness_probe` below.
     */
    @JvmName("bguqqqmfcyapivby")
    public suspend fun livenessProbes(vararg values: ContainerGroupContainerLivenessProbeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.livenessProbes = mapped
    }

    /**
     * @param value The amount of memory resources allocated to the container. Default value: `0`.
     */
    @JvmName("nfatxyttmiyxwbss")
    public suspend fun memory(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value The name of the mounted volume.
     */
    @JvmName("jemmdbxpsailvwyh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The structure of port. See `ports` below.
     */
    @JvmName("cxkootrogardfjaa")
    public suspend fun ports(`value`: List<ContainerGroupContainerPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below.
     */
    @JvmName("iklkutirovwlokka")
    public suspend fun ports(argument: List<suspend ContainerGroupContainerPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerPortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below.
     */
    @JvmName("cmpalronnhvyhqlm")
    public suspend fun ports(vararg argument: suspend ContainerGroupContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerPortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below.
     */
    @JvmName("puhstupcrvhvopau")
    public suspend fun ports(argument: suspend ContainerGroupContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerPortArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param values The structure of port. See `ports` below.
     */
    @JvmName("fdomxwtxuwhlbluu")
    public suspend fun ports(vararg values: ContainerGroupContainerPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value The health check of the container. See `readiness_probe` below.
     */
    @JvmName("gadyellgmfamsybx")
    public suspend fun readinessProbes(`value`: List<ContainerGroupContainerReadinessProbeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbes = mapped
    }

    /**
     * @param argument The health check of the container. See `readiness_probe` below.
     */
    @JvmName("atjbhxikwjcyuvfa")
    public suspend fun readinessProbes(argument: List<suspend ContainerGroupContainerReadinessProbeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerReadinessProbeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.readinessProbes = mapped
    }

    /**
     * @param argument The health check of the container. See `readiness_probe` below.
     */
    @JvmName("gbuehcopdhumpkme")
    public suspend fun readinessProbes(vararg argument: suspend ContainerGroupContainerReadinessProbeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerReadinessProbeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.readinessProbes = mapped
    }

    /**
     * @param argument The health check of the container. See `readiness_probe` below.
     */
    @JvmName("uawtdfakbcafuneu")
    public suspend fun readinessProbes(argument: suspend ContainerGroupContainerReadinessProbeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerReadinessProbeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.readinessProbes = mapped
    }

    /**
     * @param values The health check of the container. See `readiness_probe` below.
     */
    @JvmName("qfjlumbbioxwojul")
    public suspend fun readinessProbes(vararg values: ContainerGroupContainerReadinessProbeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readinessProbes = mapped
    }

    /**
     * @param value Indicates whether the container passed the readiness probe.
     */
    @JvmName("rwtfoyftthtbqdri")
    public suspend fun ready(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ready = mapped
    }

    /**
     * @param value The number of times that the container restarted.
     */
    @JvmName("ktnrqeoxgdpdokcr")
    public suspend fun restartCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartCount = mapped
    }

    /**
     * @param value The security context of the container. See `security_context` below.
     */
    @JvmName("uftvqaavwqkourdl")
    public suspend fun securityContexts(`value`: List<ContainerGroupContainerSecurityContextArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContexts = mapped
    }

    /**
     * @param argument The security context of the container. See `security_context` below.
     */
    @JvmName("cvgggxgkndfmcbcl")
    public suspend fun securityContexts(argument: List<suspend ContainerGroupContainerSecurityContextArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerSecurityContextArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityContexts = mapped
    }

    /**
     * @param argument The security context of the container. See `security_context` below.
     */
    @JvmName("fvwmnrakrfhgdhvm")
    public suspend fun securityContexts(vararg argument: suspend ContainerGroupContainerSecurityContextArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerSecurityContextArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityContexts = mapped
    }

    /**
     * @param argument The security context of the container. See `security_context` below.
     */
    @JvmName("mkexaqpkuonqsjbv")
    public suspend fun securityContexts(argument: suspend ContainerGroupContainerSecurityContextArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerSecurityContextArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.securityContexts = mapped
    }

    /**
     * @param values The security context of the container. See `security_context` below.
     */
    @JvmName("yhbldexsreqmdowr")
    public suspend fun securityContexts(vararg values: ContainerGroupContainerSecurityContextArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityContexts = mapped
    }

    /**
     * @param value The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("yrkdduiximtcfuuq")
    public suspend fun volumeMounts(`value`: List<ContainerGroupContainerVolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("sonmpshhfskuljlu")
    public suspend fun volumeMounts(argument: List<suspend ContainerGroupContainerVolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerVolumeMountArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("hivkghasxnuejgaj")
    public suspend fun volumeMounts(vararg argument: suspend ContainerGroupContainerVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerVolumeMountArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("eqweuuewrwwqfbts")
    public suspend fun volumeMounts(argument: suspend ContainerGroupContainerVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerVolumeMountArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("uoxcokxyvkgedsyp")
    public suspend fun volumeMounts(vararg values: ContainerGroupContainerVolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param value The working directory of the container.
     */
    @JvmName("bracljdunfqxtxwe")
    public suspend fun workingDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workingDir = mapped
    }

    internal fun build(): ContainerGroupContainerArgs = ContainerGroupContainerArgs(
        args = args,
        commands = commands,
        cpu = cpu,
        environmentVars = environmentVars,
        gpu = gpu,
        image = image ?: throw PulumiNullFieldException("image"),
        imagePullPolicy = imagePullPolicy,
        lifecyclePreStopHandlerExecs = lifecyclePreStopHandlerExecs,
        livenessProbes = livenessProbes,
        memory = memory,
        name = name ?: throw PulumiNullFieldException("name"),
        ports = ports,
        readinessProbes = readinessProbes,
        ready = ready,
        restartCount = restartCount,
        securityContexts = securityContexts,
        volumeMounts = volumeMounts,
        workingDir = workingDir,
    )
}
