@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupContainerLivenessProbeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property execs Health check using command line method. See `exec` below.
 * @property failureThreshold Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
 * @property httpGets Health check using HTTP request method. See `http_get` below.
 * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
 * @property initialDelaySeconds Check the time to start execution, calculated from the completion of container startup.
 * @property periodSeconds Buffer time for the program to handle operations before closing.
 * @property successThreshold The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
 * @property tcpSockets Health check using TCP socket method. See `tcp_socket` below.
 * @property timeoutSeconds Check the timeout, the default is 1 second, the minimum is 1 second.
 */
public data class ContainerGroupContainerLivenessProbeArgs(
    public val execs: Output<List<ContainerGroupContainerLivenessProbeExecArgs>>? = null,
    public val failureThreshold: Output<Int>? = null,
    public val httpGets: Output<List<ContainerGroupContainerLivenessProbeHttpGetArgs>>? = null,
    public val initialDelaySeconds: Output<Int>? = null,
    public val periodSeconds: Output<Int>? = null,
    public val successThreshold: Output<Int>? = null,
    public val tcpSockets: Output<List<ContainerGroupContainerLivenessProbeTcpSocketArgs>>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupContainerLivenessProbeArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupContainerLivenessProbeArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupContainerLivenessProbeArgs.builder()
            .execs(execs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .httpGets(
                httpGets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .initialDelaySeconds(initialDelaySeconds?.applyValue({ args0 -> args0 }))
            .periodSeconds(periodSeconds?.applyValue({ args0 -> args0 }))
            .successThreshold(successThreshold?.applyValue({ args0 -> args0 }))
            .tcpSockets(
                tcpSockets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupContainerLivenessProbeArgs].
 */
@PulumiTagMarker
public class ContainerGroupContainerLivenessProbeArgsBuilder internal constructor() {
    private var execs: Output<List<ContainerGroupContainerLivenessProbeExecArgs>>? = null

    private var failureThreshold: Output<Int>? = null

    private var httpGets: Output<List<ContainerGroupContainerLivenessProbeHttpGetArgs>>? = null

    private var initialDelaySeconds: Output<Int>? = null

    private var periodSeconds: Output<Int>? = null

    private var successThreshold: Output<Int>? = null

    private var tcpSockets: Output<List<ContainerGroupContainerLivenessProbeTcpSocketArgs>>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value Health check using command line method. See `exec` below.
     */
    @JvmName("oagilherhtugghhb")
    public suspend fun execs(`value`: Output<List<ContainerGroupContainerLivenessProbeExecArgs>>) {
        this.execs = value
    }

    @JvmName("pstwlmpkstlobdsr")
    public suspend fun execs(vararg values: Output<ContainerGroupContainerLivenessProbeExecArgs>) {
        this.execs = Output.all(values.asList())
    }

    /**
     * @param values Health check using command line method. See `exec` below.
     */
    @JvmName("dgvyxbaoliyhtiqp")
    public suspend fun execs(values: List<Output<ContainerGroupContainerLivenessProbeExecArgs>>) {
        this.execs = Output.all(values)
    }

    /**
     * @param value Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
     */
    @JvmName("expmhoampkvwlmkn")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("ihaoaolbvwtigjim")
    public suspend fun httpGets(`value`: Output<List<ContainerGroupContainerLivenessProbeHttpGetArgs>>) {
        this.httpGets = value
    }

    @JvmName("kugjacwjvvlqujra")
    public suspend fun httpGets(vararg values: Output<ContainerGroupContainerLivenessProbeHttpGetArgs>) {
        this.httpGets = Output.all(values.asList())
    }

    /**
     * @param values Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("oeuumwqbutmkiqie")
    public suspend fun httpGets(values: List<Output<ContainerGroupContainerLivenessProbeHttpGetArgs>>) {
        this.httpGets = Output.all(values)
    }

    /**
     * @param value Check the time to start execution, calculated from the completion of container startup.
     */
    @JvmName("sitfodvmiviuhgbm")
    public suspend fun initialDelaySeconds(`value`: Output<Int>) {
        this.initialDelaySeconds = value
    }

    /**
     * @param value Buffer time for the program to handle operations before closing.
     */
    @JvmName("mfcjclthbddurovx")
    public suspend fun periodSeconds(`value`: Output<Int>) {
        this.periodSeconds = value
    }

    /**
     * @param value The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
     */
    @JvmName("tsjwjdkahjhpeouv")
    public suspend fun successThreshold(`value`: Output<Int>) {
        this.successThreshold = value
    }

    /**
     * @param value Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("nduehafsatiyckkq")
    public suspend fun tcpSockets(`value`: Output<List<ContainerGroupContainerLivenessProbeTcpSocketArgs>>) {
        this.tcpSockets = value
    }

    @JvmName("kmcpghchhpbvmqbk")
    public suspend fun tcpSockets(vararg values: Output<ContainerGroupContainerLivenessProbeTcpSocketArgs>) {
        this.tcpSockets = Output.all(values.asList())
    }

    /**
     * @param values Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("smgodbvqpedorllj")
    public suspend fun tcpSockets(values: List<Output<ContainerGroupContainerLivenessProbeTcpSocketArgs>>) {
        this.tcpSockets = Output.all(values)
    }

    /**
     * @param value Check the timeout, the default is 1 second, the minimum is 1 second.
     */
    @JvmName("tccllmfnswtexqyd")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value Health check using command line method. See `exec` below.
     */
    @JvmName("soxhloqxjlohmseq")
    public suspend fun execs(`value`: List<ContainerGroupContainerLivenessProbeExecArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.execs = mapped
    }

    /**
     * @param argument Health check using command line method. See `exec` below.
     */
    @JvmName("actitnropgxefywc")
    public suspend fun execs(argument: List<suspend ContainerGroupContainerLivenessProbeExecArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerLivenessProbeExecArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.execs = mapped
    }

    /**
     * @param argument Health check using command line method. See `exec` below.
     */
    @JvmName("brwixfpvqbvfvetb")
    public suspend fun execs(vararg argument: suspend ContainerGroupContainerLivenessProbeExecArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerLivenessProbeExecArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.execs = mapped
    }

    /**
     * @param argument Health check using command line method. See `exec` below.
     */
    @JvmName("jvlpakttjftjjtxu")
    public suspend fun execs(argument: suspend ContainerGroupContainerLivenessProbeExecArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerLivenessProbeExecArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.execs = mapped
    }

    /**
     * @param values Health check using command line method. See `exec` below.
     */
    @JvmName("tqfiaqiemlmayhot")
    public suspend fun execs(vararg values: ContainerGroupContainerLivenessProbeExecArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.execs = mapped
    }

    /**
     * @param value Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
     */
    @JvmName("qlrqobhejliwnwmn")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("pbllfbtxqkoeqjwx")
    public suspend fun httpGets(`value`: List<ContainerGroupContainerLivenessProbeHttpGetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGets = mapped
    }

    /**
     * @param argument Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("uydjmqyoqnptvirj")
    public suspend fun httpGets(argument: List<suspend ContainerGroupContainerLivenessProbeHttpGetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerLivenessProbeHttpGetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpGets = mapped
    }

    /**
     * @param argument Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("hownrmiemctbyoyq")
    public suspend fun httpGets(vararg argument: suspend ContainerGroupContainerLivenessProbeHttpGetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerLivenessProbeHttpGetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpGets = mapped
    }

    /**
     * @param argument Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("pfklnqqhirqetmpr")
    public suspend fun httpGets(argument: suspend ContainerGroupContainerLivenessProbeHttpGetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerLivenessProbeHttpGetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpGets = mapped
    }

    /**
     * @param values Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("aqjgiwxpqpomoyoo")
    public suspend fun httpGets(vararg values: ContainerGroupContainerLivenessProbeHttpGetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpGets = mapped
    }

    /**
     * @param value Check the time to start execution, calculated from the completion of container startup.
     */
    @JvmName("gnedncngvvpuevwu")
    public suspend fun initialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelaySeconds = mapped
    }

    /**
     * @param value Buffer time for the program to handle operations before closing.
     */
    @JvmName("lmwqjtqjewcxhavo")
    public suspend fun periodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodSeconds = mapped
    }

    /**
     * @param value The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
     */
    @JvmName("pprhbmaeqbqnjckd")
    public suspend fun successThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successThreshold = mapped
    }

    /**
     * @param value Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("akmphyatvlsfpucx")
    public suspend fun tcpSockets(`value`: List<ContainerGroupContainerLivenessProbeTcpSocketArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpSockets = mapped
    }

    /**
     * @param argument Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("xdfbbkfdruxqydgr")
    public suspend fun tcpSockets(argument: List<suspend ContainerGroupContainerLivenessProbeTcpSocketArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerLivenessProbeTcpSocketArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tcpSockets = mapped
    }

    /**
     * @param argument Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("xpslierfxopjpwdt")
    public suspend fun tcpSockets(vararg argument: suspend ContainerGroupContainerLivenessProbeTcpSocketArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerLivenessProbeTcpSocketArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tcpSockets = mapped
    }

    /**
     * @param argument Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("tvuofkwifhogudnq")
    public suspend fun tcpSockets(argument: suspend ContainerGroupContainerLivenessProbeTcpSocketArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerLivenessProbeTcpSocketArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.tcpSockets = mapped
    }

    /**
     * @param values Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("rgvcowbqwhpxcxxs")
    public suspend fun tcpSockets(vararg values: ContainerGroupContainerLivenessProbeTcpSocketArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tcpSockets = mapped
    }

    /**
     * @param value Check the timeout, the default is 1 second, the minimum is 1 second.
     */
    @JvmName("xrpydmnhvpksjnbd")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): ContainerGroupContainerLivenessProbeArgs =
        ContainerGroupContainerLivenessProbeArgs(
            execs = execs,
            failureThreshold = failureThreshold,
            httpGets = httpGets,
            initialDelaySeconds = initialDelaySeconds,
            periodSeconds = periodSeconds,
            successThreshold = successThreshold,
            tcpSockets = tcpSockets,
            timeoutSeconds = timeoutSeconds,
        )
}
