@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupContainerPortArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port
 * @property protocol
 */
public data class ContainerGroupContainerPortArgs(
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupContainerPortArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupContainerPortArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupContainerPortArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupContainerPortArgs].
 */
@PulumiTagMarker
public class ContainerGroupContainerPortArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("arauhtqokvybrmhi")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("qiqqrlbhiqnbxklw")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value
     */
    @JvmName("tobandglufcgkegm")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("waoucsovqtqtjsfh")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): ContainerGroupContainerPortArgs = ContainerGroupContainerPortArgs(
        port = port,
        protocol = protocol,
    )
}
