@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupContainerReadinessProbeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property execs Health check using command line method. See `exec` below.
 * @property failureThreshold Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
 * @property httpGets Health check using HTTP request method. See `http_get` below.
 * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
 * @property initialDelaySeconds Check the time to start execution, calculated from the completion of container startup.
 * @property periodSeconds Buffer time for the program to handle operations before closing.
 * @property successThreshold The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
 * @property tcpSockets Health check using TCP socket method. See `tcp_socket` below.
 * @property timeoutSeconds Check the timeout, the default is 1 second, the minimum is 1 second.
 */
public data class ContainerGroupContainerReadinessProbeArgs(
    public val execs: Output<List<ContainerGroupContainerReadinessProbeExecArgs>>? = null,
    public val failureThreshold: Output<Int>? = null,
    public val httpGets: Output<List<ContainerGroupContainerReadinessProbeHttpGetArgs>>? = null,
    public val initialDelaySeconds: Output<Int>? = null,
    public val periodSeconds: Output<Int>? = null,
    public val successThreshold: Output<Int>? = null,
    public val tcpSockets: Output<List<ContainerGroupContainerReadinessProbeTcpSocketArgs>>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupContainerReadinessProbeArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupContainerReadinessProbeArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupContainerReadinessProbeArgs.builder()
            .execs(execs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .httpGets(
                httpGets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .initialDelaySeconds(initialDelaySeconds?.applyValue({ args0 -> args0 }))
            .periodSeconds(periodSeconds?.applyValue({ args0 -> args0 }))
            .successThreshold(successThreshold?.applyValue({ args0 -> args0 }))
            .tcpSockets(
                tcpSockets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupContainerReadinessProbeArgs].
 */
@PulumiTagMarker
public class ContainerGroupContainerReadinessProbeArgsBuilder internal constructor() {
    private var execs: Output<List<ContainerGroupContainerReadinessProbeExecArgs>>? = null

    private var failureThreshold: Output<Int>? = null

    private var httpGets: Output<List<ContainerGroupContainerReadinessProbeHttpGetArgs>>? = null

    private var initialDelaySeconds: Output<Int>? = null

    private var periodSeconds: Output<Int>? = null

    private var successThreshold: Output<Int>? = null

    private var tcpSockets: Output<List<ContainerGroupContainerReadinessProbeTcpSocketArgs>>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value Health check using command line method. See `exec` below.
     */
    @JvmName("yhjytiqusbholeat")
    public suspend fun execs(`value`: Output<List<ContainerGroupContainerReadinessProbeExecArgs>>) {
        this.execs = value
    }

    @JvmName("trbwmalfynwnychd")
    public suspend fun execs(vararg values: Output<ContainerGroupContainerReadinessProbeExecArgs>) {
        this.execs = Output.all(values.asList())
    }

    /**
     * @param values Health check using command line method. See `exec` below.
     */
    @JvmName("graaxreeljqyowgy")
    public suspend fun execs(values: List<Output<ContainerGroupContainerReadinessProbeExecArgs>>) {
        this.execs = Output.all(values)
    }

    /**
     * @param value Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
     */
    @JvmName("xbfbjinoeccydqtf")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("umohorxhthmuxaed")
    public suspend fun httpGets(`value`: Output<List<ContainerGroupContainerReadinessProbeHttpGetArgs>>) {
        this.httpGets = value
    }

    @JvmName("nqgoidpebvtujjec")
    public suspend fun httpGets(vararg values: Output<ContainerGroupContainerReadinessProbeHttpGetArgs>) {
        this.httpGets = Output.all(values.asList())
    }

    /**
     * @param values Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("tveskmpvryippboo")
    public suspend fun httpGets(values: List<Output<ContainerGroupContainerReadinessProbeHttpGetArgs>>) {
        this.httpGets = Output.all(values)
    }

    /**
     * @param value Check the time to start execution, calculated from the completion of container startup.
     */
    @JvmName("ugcvvxhbyklqgahp")
    public suspend fun initialDelaySeconds(`value`: Output<Int>) {
        this.initialDelaySeconds = value
    }

    /**
     * @param value Buffer time for the program to handle operations before closing.
     */
    @JvmName("qgsvskkegfgnmatk")
    public suspend fun periodSeconds(`value`: Output<Int>) {
        this.periodSeconds = value
    }

    /**
     * @param value The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
     */
    @JvmName("irqphgxkusoicemf")
    public suspend fun successThreshold(`value`: Output<Int>) {
        this.successThreshold = value
    }

    /**
     * @param value Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("iomlwmdrtyijhcjk")
    public suspend fun tcpSockets(`value`: Output<List<ContainerGroupContainerReadinessProbeTcpSocketArgs>>) {
        this.tcpSockets = value
    }

    @JvmName("pwdjydigbsuompkr")
    public suspend fun tcpSockets(vararg values: Output<ContainerGroupContainerReadinessProbeTcpSocketArgs>) {
        this.tcpSockets = Output.all(values.asList())
    }

    /**
     * @param values Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("cxdwmyewciysfgob")
    public suspend fun tcpSockets(values: List<Output<ContainerGroupContainerReadinessProbeTcpSocketArgs>>) {
        this.tcpSockets = Output.all(values)
    }

    /**
     * @param value Check the timeout, the default is 1 second, the minimum is 1 second.
     */
    @JvmName("kuprsqmtfuegbwlw")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value Health check using command line method. See `exec` below.
     */
    @JvmName("hiijdkwlyhjggbdo")
    public suspend fun execs(`value`: List<ContainerGroupContainerReadinessProbeExecArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.execs = mapped
    }

    /**
     * @param argument Health check using command line method. See `exec` below.
     */
    @JvmName("ldebuovsmnccwueh")
    public suspend fun execs(argument: List<suspend ContainerGroupContainerReadinessProbeExecArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerReadinessProbeExecArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.execs = mapped
    }

    /**
     * @param argument Health check using command line method. See `exec` below.
     */
    @JvmName("hwhajhdkbahpnwgf")
    public suspend fun execs(vararg argument: suspend ContainerGroupContainerReadinessProbeExecArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerReadinessProbeExecArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.execs = mapped
    }

    /**
     * @param argument Health check using command line method. See `exec` below.
     */
    @JvmName("vesnvkwmiflkcbrf")
    public suspend fun execs(argument: suspend ContainerGroupContainerReadinessProbeExecArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerReadinessProbeExecArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.execs = mapped
    }

    /**
     * @param values Health check using command line method. See `exec` below.
     */
    @JvmName("eoghdenlfrunqyxm")
    public suspend fun execs(vararg values: ContainerGroupContainerReadinessProbeExecArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.execs = mapped
    }

    /**
     * @param value Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
     */
    @JvmName("ivqlogjnyrpilbsj")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("nqvyprmdbynibcbo")
    public suspend fun httpGets(`value`: List<ContainerGroupContainerReadinessProbeHttpGetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGets = mapped
    }

    /**
     * @param argument Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("xxyqfupgjxhdqhas")
    public suspend fun httpGets(argument: List<suspend ContainerGroupContainerReadinessProbeHttpGetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerReadinessProbeHttpGetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpGets = mapped
    }

    /**
     * @param argument Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("vypequxntuykusou")
    public suspend fun httpGets(vararg argument: suspend ContainerGroupContainerReadinessProbeHttpGetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerReadinessProbeHttpGetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.httpGets = mapped
    }

    /**
     * @param argument Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("abokovvlijnuikdx")
    public suspend fun httpGets(argument: suspend ContainerGroupContainerReadinessProbeHttpGetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerReadinessProbeHttpGetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpGets = mapped
    }

    /**
     * @param values Health check using HTTP request method. See `http_get` below.
     * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
     */
    @JvmName("qutykubwuhikwfbv")
    public suspend fun httpGets(vararg values: ContainerGroupContainerReadinessProbeHttpGetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpGets = mapped
    }

    /**
     * @param value Check the time to start execution, calculated from the completion of container startup.
     */
    @JvmName("mqvvafsulmudorpo")
    public suspend fun initialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelaySeconds = mapped
    }

    /**
     * @param value Buffer time for the program to handle operations before closing.
     */
    @JvmName("utkqyscamcfvvsvo")
    public suspend fun periodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodSeconds = mapped
    }

    /**
     * @param value The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
     */
    @JvmName("itsiqvjfsgqkhuey")
    public suspend fun successThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successThreshold = mapped
    }

    /**
     * @param value Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("qeqhqpbfpolwtwdf")
    public suspend fun tcpSockets(`value`: List<ContainerGroupContainerReadinessProbeTcpSocketArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpSockets = mapped
    }

    /**
     * @param argument Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("uvmbsxbcmwghrxoa")
    public suspend fun tcpSockets(argument: List<suspend ContainerGroupContainerReadinessProbeTcpSocketArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerReadinessProbeTcpSocketArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tcpSockets = mapped
    }

    /**
     * @param argument Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("tmtoljepudffhvpd")
    public suspend fun tcpSockets(vararg argument: suspend ContainerGroupContainerReadinessProbeTcpSocketArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerReadinessProbeTcpSocketArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tcpSockets = mapped
    }

    /**
     * @param argument Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("fxkcamxkinbofrbv")
    public suspend fun tcpSockets(argument: suspend ContainerGroupContainerReadinessProbeTcpSocketArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupContainerReadinessProbeTcpSocketArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.tcpSockets = mapped
    }

    /**
     * @param values Health check using TCP socket method. See `tcp_socket` below.
     */
    @JvmName("nltdgbddbiyracql")
    public suspend fun tcpSockets(vararg values: ContainerGroupContainerReadinessProbeTcpSocketArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tcpSockets = mapped
    }

    /**
     * @param value Check the timeout, the default is 1 second, the minimum is 1 second.
     */
    @JvmName("oioyjkdopkkqkgwi")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): ContainerGroupContainerReadinessProbeArgs =
        ContainerGroupContainerReadinessProbeArgs(
            execs = execs,
            failureThreshold = failureThreshold,
            httpGets = httpGets,
            initialDelaySeconds = initialDelaySeconds,
            periodSeconds = periodSeconds,
            successThreshold = successThreshold,
            tcpSockets = tcpSockets,
            timeoutSeconds = timeoutSeconds,
        )
}
