@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupContainerReadinessProbeHttpGetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property path
 * @property port
 * @property scheme The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
 */
public data class ContainerGroupContainerReadinessProbeHttpGetArgs(
    public val path: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val scheme: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupContainerReadinessProbeHttpGetArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupContainerReadinessProbeHttpGetArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupContainerReadinessProbeHttpGetArgs.builder()
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .scheme(scheme?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupContainerReadinessProbeHttpGetArgs].
 */
@PulumiTagMarker
public class ContainerGroupContainerReadinessProbeHttpGetArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var port: Output<Int>? = null

    private var scheme: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("jtoaxkecqvrlxyto")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value
     */
    @JvmName("yuwxwrlqldoksyhj")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
     */
    @JvmName("mmxomablurgnqwmh")
    public suspend fun scheme(`value`: Output<String>) {
        this.scheme = value
    }

    /**
     * @param value
     */
    @JvmName("hooyhsgcvmvgbrrv")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value
     */
    @JvmName("dbqqevpcongakvdw")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol type corresponding to the HTTP Get request when using the HTTP request method for health checks. Valid values: `HTTP`, `HTTPS`.
     */
    @JvmName("spovjujtohmdbhjy")
    public suspend fun scheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    internal fun build(): ContainerGroupContainerReadinessProbeHttpGetArgs =
        ContainerGroupContainerReadinessProbeHttpGetArgs(
            path = path,
            port = port,
            scheme = scheme,
        )
}
