@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupContainerSecurityContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property capabilities
 * @property privileged Specifies whether to give extended privileges to this container. Default value: `false`. Valid values: `true` and `false`.
 * @property runAsUser
 */
public data class ContainerGroupContainerSecurityContextArgs(
    public val capabilities: Output<List<ContainerGroupContainerSecurityContextCapabilityArgs>>? =
        null,
    public val privileged: Output<Boolean>? = null,
    public val runAsUser: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupContainerSecurityContextArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupContainerSecurityContextArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupContainerSecurityContextArgs.builder()
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .privileged(privileged?.applyValue({ args0 -> args0 }))
            .runAsUser(runAsUser?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupContainerSecurityContextArgs].
 */
@PulumiTagMarker
public class ContainerGroupContainerSecurityContextArgsBuilder internal constructor() {
    private var capabilities: Output<List<ContainerGroupContainerSecurityContextCapabilityArgs>>? =
        null

    private var privileged: Output<Boolean>? = null

    private var runAsUser: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("eowfoblrdnkychej")
    public suspend fun capabilities(`value`: Output<List<ContainerGroupContainerSecurityContextCapabilityArgs>>) {
        this.capabilities = value
    }

    @JvmName("noeqsddhbdwehktv")
    public suspend fun capabilities(vararg values: Output<ContainerGroupContainerSecurityContextCapabilityArgs>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("hntskauhipnedjim")
    public suspend fun capabilities(values: List<Output<ContainerGroupContainerSecurityContextCapabilityArgs>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value Specifies whether to give extended privileges to this container. Default value: `false`. Valid values: `true` and `false`.
     */
    @JvmName("lngeohyjankcinul")
    public suspend fun privileged(`value`: Output<Boolean>) {
        this.privileged = value
    }

    /**
     * @param value
     */
    @JvmName("xcpbvuypncwqhyxo")
    public suspend fun runAsUser(`value`: Output<Int>) {
        this.runAsUser = value
    }

    /**
     * @param value
     */
    @JvmName("wmwymawyjfunrvwl")
    public suspend fun capabilities(`value`: List<ContainerGroupContainerSecurityContextCapabilityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rnvvagghyurtnynp")
    public suspend fun capabilities(argument: List<suspend ContainerGroupContainerSecurityContextCapabilityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerSecurityContextCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rejewlffegsqroem")
    public suspend fun capabilities(vararg argument: suspend ContainerGroupContainerSecurityContextCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupContainerSecurityContextCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("upyemvcmahgfshog")
    public suspend fun capabilities(argument: suspend ContainerGroupContainerSecurityContextCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ContainerGroupContainerSecurityContextCapabilityArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param values
     */
    @JvmName("xutdqcarfqymnyce")
    public suspend fun capabilities(vararg values: ContainerGroupContainerSecurityContextCapabilityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value Specifies whether to give extended privileges to this container. Default value: `false`. Valid values: `true` and `false`.
     */
    @JvmName("vymisfxgjnoiomcj")
    public suspend fun privileged(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privileged = mapped
    }

    /**
     * @param value
     */
    @JvmName("qnnqxmxtpufmwkfp")
    public suspend fun runAsUser(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsUser = mapped
    }

    internal fun build(): ContainerGroupContainerSecurityContextArgs =
        ContainerGroupContainerSecurityContextArgs(
            capabilities = capabilities,
            privileged = privileged,
            runAsUser = runAsUser,
        )
}
