@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupContainerVolumeMountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mountPath
 * @property name
 * @property readOnly
 */
public data class ContainerGroupContainerVolumeMountArgs(
    public val mountPath: Output<String>? = null,
    public val name: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupContainerVolumeMountArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupContainerVolumeMountArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupContainerVolumeMountArgs.builder()
            .mountPath(mountPath?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupContainerVolumeMountArgs].
 */
@PulumiTagMarker
public class ContainerGroupContainerVolumeMountArgsBuilder internal constructor() {
    private var mountPath: Output<String>? = null

    private var name: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("hhmuwiaegcsbvfmm")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value
     */
    @JvmName("ltobduisnbyyepbs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("ytimvityotkvtlyi")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value
     */
    @JvmName("ynxrfijgsjcdjibc")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value
     */
    @JvmName("xgotnhtaihnepodb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("xnenuxlykoghdrgh")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): ContainerGroupContainerVolumeMountArgs =
        ContainerGroupContainerVolumeMountArgs(
            mountPath = mountPath,
            name = name,
            readOnly = readOnly,
        )
}
