@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupDnsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property nameServers The list of DNS server IP addresses.
 * @property options The structure of options. See `options` below.
 * @property searches The list of DNS lookup domains.
 */
public data class ContainerGroupDnsConfigArgs(
    public val nameServers: Output<List<String>>? = null,
    public val options: Output<List<ContainerGroupDnsConfigOptionArgs>>? = null,
    public val searches: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupDnsConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupDnsConfigArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupDnsConfigArgs.builder()
            .nameServers(nameServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .options(
                options?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .searches(searches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ContainerGroupDnsConfigArgs].
 */
@PulumiTagMarker
public class ContainerGroupDnsConfigArgsBuilder internal constructor() {
    private var nameServers: Output<List<String>>? = null

    private var options: Output<List<ContainerGroupDnsConfigOptionArgs>>? = null

    private var searches: Output<List<String>>? = null

    /**
     * @param value The list of DNS server IP addresses.
     */
    @JvmName("qtckctnfdgqfvdoy")
    public suspend fun nameServers(`value`: Output<List<String>>) {
        this.nameServers = value
    }

    @JvmName("vvdmogkjemnbpvpy")
    public suspend fun nameServers(vararg values: Output<String>) {
        this.nameServers = Output.all(values.asList())
    }

    /**
     * @param values The list of DNS server IP addresses.
     */
    @JvmName("wpfnlqpodrfsfqii")
    public suspend fun nameServers(values: List<Output<String>>) {
        this.nameServers = Output.all(values)
    }

    /**
     * @param value The structure of options. See `options` below.
     */
    @JvmName("fojnxvxhvbxujnww")
    public suspend fun options(`value`: Output<List<ContainerGroupDnsConfigOptionArgs>>) {
        this.options = value
    }

    @JvmName("uurdbbefseeibrxr")
    public suspend fun options(vararg values: Output<ContainerGroupDnsConfigOptionArgs>) {
        this.options = Output.all(values.asList())
    }

    /**
     * @param values The structure of options. See `options` below.
     */
    @JvmName("tnyuegoahchavpjq")
    public suspend fun options(values: List<Output<ContainerGroupDnsConfigOptionArgs>>) {
        this.options = Output.all(values)
    }

    /**
     * @param value The list of DNS lookup domains.
     */
    @JvmName("asuihrhbalmvhcfb")
    public suspend fun searches(`value`: Output<List<String>>) {
        this.searches = value
    }

    @JvmName("hhdpdyprojtahifr")
    public suspend fun searches(vararg values: Output<String>) {
        this.searches = Output.all(values.asList())
    }

    /**
     * @param values The list of DNS lookup domains.
     */
    @JvmName("haxbsyakimpifhwp")
    public suspend fun searches(values: List<Output<String>>) {
        this.searches = Output.all(values)
    }

    /**
     * @param value The list of DNS server IP addresses.
     */
    @JvmName("fisulfqmpudqexjh")
    public suspend fun nameServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param values The list of DNS server IP addresses.
     */
    @JvmName("npiorcnwpsidfdsr")
    public suspend fun nameServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param value The structure of options. See `options` below.
     */
    @JvmName("droebmfqcpkhdkwe")
    public suspend fun options(`value`: List<ContainerGroupDnsConfigOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument The structure of options. See `options` below.
     */
    @JvmName("cxcnqhbjdbnvbwxx")
    public suspend fun options(argument: List<suspend ContainerGroupDnsConfigOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupDnsConfigOptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param argument The structure of options. See `options` below.
     */
    @JvmName("qahgncvpxbmcinwd")
    public suspend fun options(vararg argument: suspend ContainerGroupDnsConfigOptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupDnsConfigOptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param argument The structure of options. See `options` below.
     */
    @JvmName("cempbbvlqvfgwwtt")
    public suspend fun options(argument: suspend ContainerGroupDnsConfigOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupDnsConfigOptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param values The structure of options. See `options` below.
     */
    @JvmName("jcbkqbsrxsdrhvik")
    public suspend fun options(vararg values: ContainerGroupDnsConfigOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value The list of DNS lookup domains.
     */
    @JvmName("tadooppuhcwqxmlm")
    public suspend fun searches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searches = mapped
    }

    /**
     * @param values The list of DNS lookup domains.
     */
    @JvmName("pctcnhadqrihxstm")
    public suspend fun searches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searches = mapped
    }

    internal fun build(): ContainerGroupDnsConfigArgs = ContainerGroupDnsConfigArgs(
        nameServers = nameServers,
        options = options,
        searches = searches,
    )
}
