@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupDnsConfigOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name
 * @property value
 */
public data class ContainerGroupDnsConfigOptionArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupDnsConfigOptionArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupDnsConfigOptionArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupDnsConfigOptionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupDnsConfigOptionArgs].
 */
@PulumiTagMarker
public class ContainerGroupDnsConfigOptionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("lgsmoixbiiymordm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("yycabfdbwsqjomfs")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value
     */
    @JvmName("tluwswvgoclnxigd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("hxkciqymcfsrsdcn")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ContainerGroupDnsConfigOptionArgs = ContainerGroupDnsConfigOptionArgs(
        name = name,
        `value` = `value`,
    )
}
