@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupHostAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hostnames The information about the host.
 * @property ip The IP address of the host.
 */
public data class ContainerGroupHostAliasArgs(
    public val hostnames: Output<List<String>>? = null,
    public val ip: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupHostAliasArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupHostAliasArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupHostAliasArgs.builder()
            .hostnames(hostnames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ip(ip?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupHostAliasArgs].
 */
@PulumiTagMarker
public class ContainerGroupHostAliasArgsBuilder internal constructor() {
    private var hostnames: Output<List<String>>? = null

    private var ip: Output<String>? = null

    /**
     * @param value The information about the host.
     */
    @JvmName("puoeaqfqpdjadxks")
    public suspend fun hostnames(`value`: Output<List<String>>) {
        this.hostnames = value
    }

    @JvmName("rvjuwbuksdxytcor")
    public suspend fun hostnames(vararg values: Output<String>) {
        this.hostnames = Output.all(values.asList())
    }

    /**
     * @param values The information about the host.
     */
    @JvmName("tecvvnjuvfrmnyfi")
    public suspend fun hostnames(values: List<Output<String>>) {
        this.hostnames = Output.all(values)
    }

    /**
     * @param value The IP address of the host.
     */
    @JvmName("mpcqhropmfoysjuv")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The information about the host.
     */
    @JvmName("rehkycqcbjdgmklt")
    public suspend fun hostnames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostnames = mapped
    }

    /**
     * @param values The information about the host.
     */
    @JvmName("rwourvwagjcknfsc")
    public suspend fun hostnames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostnames = mapped
    }

    /**
     * @param value The IP address of the host.
     */
    @JvmName("xdaigtlynyaocqvt")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    internal fun build(): ContainerGroupHostAliasArgs = ContainerGroupHostAliasArgs(
        hostnames = hostnames,
        ip = ip,
    )
}
