@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupImageRegistryCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password The password used to log on to the image repository. It is required when `image_registry_credential` is configured.
 * @property server The address of the image repository. It is required when `image_registry_credential` is configured.
 * @property userName The username used to log on to the image repository. It is required when `image_registry_credential` is configured.
 */
public data class ContainerGroupImageRegistryCredentialArgs(
    public val password: Output<String>,
    public val server: Output<String>,
    public val userName: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupImageRegistryCredentialArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupImageRegistryCredentialArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupImageRegistryCredentialArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupImageRegistryCredentialArgs].
 */
@PulumiTagMarker
public class ContainerGroupImageRegistryCredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var server: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The password used to log on to the image repository. It is required when `image_registry_credential` is configured.
     */
    @JvmName("kusvhikmtkcpslsv")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The address of the image repository. It is required when `image_registry_credential` is configured.
     */
    @JvmName("vsuowwcrvgofqexq")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The username used to log on to the image repository. It is required when `image_registry_credential` is configured.
     */
    @JvmName("sdxrjpeswcfxkwbe")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The password used to log on to the image repository. It is required when `image_registry_credential` is configured.
     */
    @JvmName("jdubqqmjgwvrjybx")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The address of the image repository. It is required when `image_registry_credential` is configured.
     */
    @JvmName("pcnidqchxcxwthkj")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The username used to log on to the image repository. It is required when `image_registry_credential` is configured.
     */
    @JvmName("iwwubbptmgkkfgtb")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ContainerGroupImageRegistryCredentialArgs =
        ContainerGroupImageRegistryCredentialArgs(
            password = password ?: throw PulumiNullFieldException("password"),
            server = server ?: throw PulumiNullFieldException("server"),
            userName = userName ?: throw PulumiNullFieldException("userName"),
        )
}
