@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property args The arguments passed to the commands.
 * @property commands The commands run by the init container.
 * @property cpu The amount of CPU resources allocated to the container. Default value: `0`.
 * @property environmentVars The structure of environmentVars. See `environment_vars` below.
 * @property gpu The number GPUs. Default value: `0`.
 * @property image The image of the container.
 * @property imagePullPolicy The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
 * @property memory The amount of memory resources allocated to the container. Default value: `0`.
 * @property name The name of the mounted volume.
 * @property ports The structure of port. See `ports` below.
 * @property ready Indicates whether the container passed the readiness probe.
 * @property restartCount The number of times that the container restarted.
 * @property securityContexts The security context of the container. See `security_context` below.
 * @property volumeMounts The structure of volumeMounts. See `volume_mounts` below.
 * @property workingDir The working directory of the container.
 */
public data class ContainerGroupInitContainerArgs(
    public val args: Output<List<String>>? = null,
    public val commands: Output<List<String>>? = null,
    public val cpu: Output<Double>? = null,
    public val environmentVars: Output<List<ContainerGroupInitContainerEnvironmentVarArgs>>? = null,
    public val gpu: Output<Int>? = null,
    public val image: Output<String>? = null,
    public val imagePullPolicy: Output<String>? = null,
    public val memory: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val ports: Output<List<ContainerGroupInitContainerPortArgs>>? = null,
    public val ready: Output<Boolean>? = null,
    public val restartCount: Output<Int>? = null,
    public val securityContexts: Output<List<ContainerGroupInitContainerSecurityContextArgs>>? = null,
    public val volumeMounts: Output<List<ContainerGroupInitContainerVolumeMountArgs>>? = null,
    public val workingDir: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .environmentVars(
                environmentVars?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gpu(gpu?.applyValue({ args0 -> args0 }))
            .image(image?.applyValue({ args0 -> args0 }))
            .imagePullPolicy(imagePullPolicy?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ready(ready?.applyValue({ args0 -> args0 }))
            .restartCount(restartCount?.applyValue({ args0 -> args0 }))
            .securityContexts(
                securityContexts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .workingDir(workingDir?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupInitContainerArgs].
 */
@PulumiTagMarker
public class ContainerGroupInitContainerArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var commands: Output<List<String>>? = null

    private var cpu: Output<Double>? = null

    private var environmentVars: Output<List<ContainerGroupInitContainerEnvironmentVarArgs>>? = null

    private var gpu: Output<Int>? = null

    private var image: Output<String>? = null

    private var imagePullPolicy: Output<String>? = null

    private var memory: Output<Double>? = null

    private var name: Output<String>? = null

    private var ports: Output<List<ContainerGroupInitContainerPortArgs>>? = null

    private var ready: Output<Boolean>? = null

    private var restartCount: Output<Int>? = null

    private var securityContexts: Output<List<ContainerGroupInitContainerSecurityContextArgs>>? = null

    private var volumeMounts: Output<List<ContainerGroupInitContainerVolumeMountArgs>>? = null

    private var workingDir: Output<String>? = null

    /**
     * @param value The arguments passed to the commands.
     */
    @JvmName("dxoogojwwbviygdc")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("mkkryefmixthktrm")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values The arguments passed to the commands.
     */
    @JvmName("ukfuphdrtlyowvuj")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value The commands run by the init container.
     */
    @JvmName("hsgnurfpwlehvfdl")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("kkqykqwhjirboyyp")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values The commands run by the init container.
     */
    @JvmName("cjdlueliwevjbcen")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value The amount of CPU resources allocated to the container. Default value: `0`.
     */
    @JvmName("rnskgwtyajgxhhcu")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("hasklypsgwlrwmhm")
    public suspend fun environmentVars(`value`: Output<List<ContainerGroupInitContainerEnvironmentVarArgs>>) {
        this.environmentVars = value
    }

    @JvmName("hssstjviyddkuabl")
    public suspend fun environmentVars(vararg values: Output<ContainerGroupInitContainerEnvironmentVarArgs>) {
        this.environmentVars = Output.all(values.asList())
    }

    /**
     * @param values The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("rnjskurnulkvghno")
    public suspend fun environmentVars(values: List<Output<ContainerGroupInitContainerEnvironmentVarArgs>>) {
        this.environmentVars = Output.all(values)
    }

    /**
     * @param value The number GPUs. Default value: `0`.
     */
    @JvmName("wjvjwteuqwnfgtyy")
    public suspend fun gpu(`value`: Output<Int>) {
        this.gpu = value
    }

    /**
     * @param value The image of the container.
     */
    @JvmName("ytjupjfgrqjukjvm")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
     */
    @JvmName("oquchmdrvenkenvq")
    public suspend fun imagePullPolicy(`value`: Output<String>) {
        this.imagePullPolicy = value
    }

    /**
     * @param value The amount of memory resources allocated to the container. Default value: `0`.
     */
    @JvmName("nabyscpmbguuirlj")
    public suspend fun memory(`value`: Output<Double>) {
        this.memory = value
    }

    /**
     * @param value The name of the mounted volume.
     */
    @JvmName("luqviukpvtjxukwc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The structure of port. See `ports` below.
     */
    @JvmName("ladijtbaupayqwrv")
    public suspend fun ports(`value`: Output<List<ContainerGroupInitContainerPortArgs>>) {
        this.ports = value
    }

    @JvmName("inyqvfahybebuymc")
    public suspend fun ports(vararg values: Output<ContainerGroupInitContainerPortArgs>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values The structure of port. See `ports` below.
     */
    @JvmName("grhyovtursraqvau")
    public suspend fun ports(values: List<Output<ContainerGroupInitContainerPortArgs>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Indicates whether the container passed the readiness probe.
     */
    @JvmName("fwgtjkkmbplbghja")
    public suspend fun ready(`value`: Output<Boolean>) {
        this.ready = value
    }

    /**
     * @param value The number of times that the container restarted.
     */
    @JvmName("tvxklhdmnuhenccc")
    public suspend fun restartCount(`value`: Output<Int>) {
        this.restartCount = value
    }

    /**
     * @param value The security context of the container. See `security_context` below.
     */
    @JvmName("qoypiodurirdwqus")
    public suspend fun securityContexts(`value`: Output<List<ContainerGroupInitContainerSecurityContextArgs>>) {
        this.securityContexts = value
    }

    @JvmName("ronmbqeiohoujrab")
    public suspend fun securityContexts(vararg values: Output<ContainerGroupInitContainerSecurityContextArgs>) {
        this.securityContexts = Output.all(values.asList())
    }

    /**
     * @param values The security context of the container. See `security_context` below.
     */
    @JvmName("liptvxrshrxolwxy")
    public suspend fun securityContexts(values: List<Output<ContainerGroupInitContainerSecurityContextArgs>>) {
        this.securityContexts = Output.all(values)
    }

    /**
     * @param value The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("ancaesyshqcwidfo")
    public suspend fun volumeMounts(`value`: Output<List<ContainerGroupInitContainerVolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("pscdnpsrypbnusst")
    public suspend fun volumeMounts(vararg values: Output<ContainerGroupInitContainerVolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("uglsadpkiahxmawo")
    public suspend fun volumeMounts(values: List<Output<ContainerGroupInitContainerVolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value The working directory of the container.
     */
    @JvmName("cnxhjvmagnxblaiw")
    public suspend fun workingDir(`value`: Output<String>) {
        this.workingDir = value
    }

    /**
     * @param value The arguments passed to the commands.
     */
    @JvmName("urqnllvsnixjmxqv")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values The arguments passed to the commands.
     */
    @JvmName("uktermnedsxcleiw")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value The commands run by the init container.
     */
    @JvmName("kdvfwvjhlmuauwgl")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values The commands run by the init container.
     */
    @JvmName("nsmnsbqoocwetgmx")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value The amount of CPU resources allocated to the container. Default value: `0`.
     */
    @JvmName("blxufbtdweeclxeq")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("rftdssgnqarevhys")
    public suspend fun environmentVars(`value`: List<ContainerGroupInitContainerEnvironmentVarArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("knyjuleaxxmuhlia")
    public suspend fun environmentVars(argument: List<suspend ContainerGroupInitContainerEnvironmentVarArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerEnvironmentVarArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("gxumipembeeakisj")
    public suspend fun environmentVars(vararg argument: suspend ContainerGroupInitContainerEnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerEnvironmentVarArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("nlejrqrorwnhcgbj")
    public suspend fun environmentVars(argument: suspend ContainerGroupInitContainerEnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupInitContainerEnvironmentVarArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param values The structure of environmentVars. See `environment_vars` below.
     */
    @JvmName("wpdebojncqtqrjpe")
    public suspend fun environmentVars(vararg values: ContainerGroupInitContainerEnvironmentVarArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVars = mapped
    }

    /**
     * @param value The number GPUs. Default value: `0`.
     */
    @JvmName("ebpvxnelenywlmaq")
    public suspend fun gpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpu = mapped
    }

    /**
     * @param value The image of the container.
     */
    @JvmName("hogudbjrwjdfnlug")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
     */
    @JvmName("tmbnssiedoutnhtd")
    public suspend fun imagePullPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePullPolicy = mapped
    }

    /**
     * @param value The amount of memory resources allocated to the container. Default value: `0`.
     */
    @JvmName("wlnnisqtiywfvwhi")
    public suspend fun memory(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value The name of the mounted volume.
     */
    @JvmName("wtkrfpmubwgnygnd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The structure of port. See `ports` below.
     */
    @JvmName("fysgcmdlklokjqdo")
    public suspend fun ports(`value`: List<ContainerGroupInitContainerPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below.
     */
    @JvmName("upibcrybxcxporqx")
    public suspend fun ports(argument: List<suspend ContainerGroupInitContainerPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below.
     */
    @JvmName("nktlcocfqwkpavqi")
    public suspend fun ports(vararg argument: suspend ContainerGroupInitContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below.
     */
    @JvmName("xoackdbwmrrwkrwq")
    public suspend fun ports(argument: suspend ContainerGroupInitContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupInitContainerPortArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param values The structure of port. See `ports` below.
     */
    @JvmName("qtecybrfxqosbcea")
    public suspend fun ports(vararg values: ContainerGroupInitContainerPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value Indicates whether the container passed the readiness probe.
     */
    @JvmName("khcwotbikiywvfam")
    public suspend fun ready(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ready = mapped
    }

    /**
     * @param value The number of times that the container restarted.
     */
    @JvmName("sajedessvsklvyms")
    public suspend fun restartCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartCount = mapped
    }

    /**
     * @param value The security context of the container. See `security_context` below.
     */
    @JvmName("ubnrekwqcgyinikn")
    public suspend fun securityContexts(`value`: List<ContainerGroupInitContainerSecurityContextArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContexts = mapped
    }

    /**
     * @param argument The security context of the container. See `security_context` below.
     */
    @JvmName("yqhsnqubpnjyvpho")
    public suspend fun securityContexts(argument: List<suspend ContainerGroupInitContainerSecurityContextArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerSecurityContextArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityContexts = mapped
    }

    /**
     * @param argument The security context of the container. See `security_context` below.
     */
    @JvmName("mngkepybvtvbgkdn")
    public suspend fun securityContexts(vararg argument: suspend ContainerGroupInitContainerSecurityContextArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerSecurityContextArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityContexts = mapped
    }

    /**
     * @param argument The security context of the container. See `security_context` below.
     */
    @JvmName("roobwmsyyiqimldb")
    public suspend fun securityContexts(argument: suspend ContainerGroupInitContainerSecurityContextArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupInitContainerSecurityContextArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.securityContexts = mapped
    }

    /**
     * @param values The security context of the container. See `security_context` below.
     */
    @JvmName("yvtgbfrusvteqkic")
    public suspend fun securityContexts(vararg values: ContainerGroupInitContainerSecurityContextArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityContexts = mapped
    }

    /**
     * @param value The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("tfxfwcffeuwfnfmh")
    public suspend fun volumeMounts(`value`: List<ContainerGroupInitContainerVolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("rlrmkfdhffkinskx")
    public suspend fun volumeMounts(argument: List<suspend ContainerGroupInitContainerVolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerVolumeMountArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("tuukilbgqpwfjafv")
    public suspend fun volumeMounts(vararg argument: suspend ContainerGroupInitContainerVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerVolumeMountArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("srgooioqhvflcgxw")
    public suspend fun volumeMounts(argument: suspend ContainerGroupInitContainerVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupInitContainerVolumeMountArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values The structure of volumeMounts. See `volume_mounts` below.
     */
    @JvmName("calflklrkfxopdgj")
    public suspend fun volumeMounts(vararg values: ContainerGroupInitContainerVolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param value The working directory of the container.
     */
    @JvmName("sosqafakkxgcvsyj")
    public suspend fun workingDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workingDir = mapped
    }

    internal fun build(): ContainerGroupInitContainerArgs = ContainerGroupInitContainerArgs(
        args = args,
        commands = commands,
        cpu = cpu,
        environmentVars = environmentVars,
        gpu = gpu,
        image = image,
        imagePullPolicy = imagePullPolicy,
        memory = memory,
        name = name,
        ports = ports,
        ready = ready,
        restartCount = restartCount,
        securityContexts = securityContexts,
        volumeMounts = volumeMounts,
        workingDir = workingDir,
    )
}
