@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerSecurityContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property capabilities
 * @property runAsUser
 */
public data class ContainerGroupInitContainerSecurityContextArgs(
    public val capabilities: Output<List<ContainerGroupInitContainerSecurityContextCapabilityArgs>>? =
        null,
    public val runAsUser: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerSecurityContextArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerSecurityContextArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerSecurityContextArgs.builder()
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .runAsUser(runAsUser?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupInitContainerSecurityContextArgs].
 */
@PulumiTagMarker
public class ContainerGroupInitContainerSecurityContextArgsBuilder internal constructor() {
    private var capabilities: Output<List<ContainerGroupInitContainerSecurityContextCapabilityArgs>>? =
        null

    private var runAsUser: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("sfcqwsbebtleyolr")
    public suspend fun capabilities(`value`: Output<List<ContainerGroupInitContainerSecurityContextCapabilityArgs>>) {
        this.capabilities = value
    }

    @JvmName("vmvvfrvqckujfpke")
    public suspend fun capabilities(vararg values: Output<ContainerGroupInitContainerSecurityContextCapabilityArgs>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("losxgycgocoyqthd")
    public suspend fun capabilities(values: List<Output<ContainerGroupInitContainerSecurityContextCapabilityArgs>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qrbimxdjixgscoqs")
    public suspend fun runAsUser(`value`: Output<Int>) {
        this.runAsUser = value
    }

    /**
     * @param value
     */
    @JvmName("dvqxtittsfhfbqxa")
    public suspend fun capabilities(`value`: List<ContainerGroupInitContainerSecurityContextCapabilityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("avgjrnfakhupetep")
    public suspend fun capabilities(argument: List<suspend ContainerGroupInitContainerSecurityContextCapabilityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerSecurityContextCapabilityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jajxrayfbtlmakls")
    public suspend fun capabilities(vararg argument: suspend ContainerGroupInitContainerSecurityContextCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupInitContainerSecurityContextCapabilityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("spygryphmuiiphmw")
    public suspend fun capabilities(argument: suspend ContainerGroupInitContainerSecurityContextCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ContainerGroupInitContainerSecurityContextCapabilityArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param values
     */
    @JvmName("irtupdfjpucycnfc")
    public suspend fun capabilities(vararg values: ContainerGroupInitContainerSecurityContextCapabilityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value
     */
    @JvmName("wdodtcchenhllwgf")
    public suspend fun runAsUser(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsUser = mapped
    }

    internal fun build(): ContainerGroupInitContainerSecurityContextArgs =
        ContainerGroupInitContainerSecurityContextArgs(
            capabilities = capabilities,
            runAsUser = runAsUser,
        )
}
