@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerVolumeMountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mountPath
 * @property name
 * @property readOnly
 */
public data class ContainerGroupInitContainerVolumeMountArgs(
    public val mountPath: Output<String>? = null,
    public val name: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerVolumeMountArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerVolumeMountArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupInitContainerVolumeMountArgs.builder()
            .mountPath(mountPath?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupInitContainerVolumeMountArgs].
 */
@PulumiTagMarker
public class ContainerGroupInitContainerVolumeMountArgsBuilder internal constructor() {
    private var mountPath: Output<String>? = null

    private var name: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("bxtfythxftyndmvp")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value
     */
    @JvmName("ymajdaeydspvxbcj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("xokdsrqedhiuhart")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value
     */
    @JvmName("efvnqydsrndcwfcr")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value
     */
    @JvmName("ybxhmswuedspibwt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("awobnjrknqvimune")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): ContainerGroupInitContainerVolumeMountArgs =
        ContainerGroupInitContainerVolumeMountArgs(
            mountPath = mountPath,
            name = name,
            readOnly = readOnly,
        )
}
