@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupSecurityContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property sysctls Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
 */
public data class ContainerGroupSecurityContextArgs(
    public val sysctls: Output<List<ContainerGroupSecurityContextSysctlArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupSecurityContextArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupSecurityContextArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupSecurityContextArgs.builder()
            .sysctls(
                sysctls?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerGroupSecurityContextArgs].
 */
@PulumiTagMarker
public class ContainerGroupSecurityContextArgsBuilder internal constructor() {
    private var sysctls: Output<List<ContainerGroupSecurityContextSysctlArgs>>? = null

    /**
     * @param value Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
     */
    @JvmName("kcdiejqaxjcbwyrx")
    public suspend fun sysctls(`value`: Output<List<ContainerGroupSecurityContextSysctlArgs>>) {
        this.sysctls = value
    }

    @JvmName("vsvhiqelrybyuhhw")
    public suspend fun sysctls(vararg values: Output<ContainerGroupSecurityContextSysctlArgs>) {
        this.sysctls = Output.all(values.asList())
    }

    /**
     * @param values Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
     */
    @JvmName("kwsdgrcilvoatjdl")
    public suspend fun sysctls(values: List<Output<ContainerGroupSecurityContextSysctlArgs>>) {
        this.sysctls = Output.all(values)
    }

    /**
     * @param value Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
     */
    @JvmName("qygddmvftekhkquc")
    public suspend fun sysctls(`value`: List<ContainerGroupSecurityContextSysctlArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sysctls = mapped
    }

    /**
     * @param argument Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
     */
    @JvmName("bobrpdavhleoseum")
    public suspend fun sysctls(argument: List<suspend ContainerGroupSecurityContextSysctlArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupSecurityContextSysctlArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sysctls = mapped
    }

    /**
     * @param argument Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
     */
    @JvmName("dpuganylwseevawn")
    public suspend fun sysctls(vararg argument: suspend ContainerGroupSecurityContextSysctlArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupSecurityContextSysctlArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sysctls = mapped
    }

    /**
     * @param argument Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
     */
    @JvmName("bfmotyclmkcxheve")
    public suspend fun sysctls(argument: suspend ContainerGroupSecurityContextSysctlArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerGroupSecurityContextSysctlArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sysctls = mapped
    }

    /**
     * @param values Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. See `sysctl` below.
     */
    @JvmName("aoruxsojpjsamlve")
    public suspend fun sysctls(vararg values: ContainerGroupSecurityContextSysctlArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sysctls = mapped
    }

    internal fun build(): ContainerGroupSecurityContextArgs = ContainerGroupSecurityContextArgs(
        sysctls = sysctls,
    )
}
