@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property configFileVolumeConfigFileToPaths The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
 * > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
 * @property diskVolumeDiskId The ID of DiskVolume.
 * @property diskVolumeFsType The system type of DiskVolume.
 * @property flexVolumeDriver The name of the FlexVolume driver.
 * @property flexVolumeFsType The type of the mounted file system. The default value is determined by the script of FlexVolume.
 * @property flexVolumeOptions The list of FlexVolume objects. Each object is a key-value pair contained in a JSON string.
 * @property name The name of the volume.
 * @property nfsVolumePath The path to the NFS volume.
 * @property nfsVolumeReadOnly The nfs volume read only. Default value: `false`.
 * @property nfsVolumeServer The address of the NFS server.
 * @property type The type of the volume.
 */
public data class ContainerGroupVolumeArgs(
    public val configFileVolumeConfigFileToPaths: Output<List<ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs>>? = null,
    public val diskVolumeDiskId: Output<String>? = null,
    public val diskVolumeFsType: Output<String>? = null,
    public val flexVolumeDriver: Output<String>? = null,
    public val flexVolumeFsType: Output<String>? = null,
    public val flexVolumeOptions: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nfsVolumePath: Output<String>? = null,
    public val nfsVolumeReadOnly: Output<Boolean>? = null,
    public val nfsVolumeServer: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupVolumeArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupVolumeArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupVolumeArgs.builder()
            .configFileVolumeConfigFileToPaths(
                configFileVolumeConfigFileToPaths?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .diskVolumeDiskId(diskVolumeDiskId?.applyValue({ args0 -> args0 }))
            .diskVolumeFsType(diskVolumeFsType?.applyValue({ args0 -> args0 }))
            .flexVolumeDriver(flexVolumeDriver?.applyValue({ args0 -> args0 }))
            .flexVolumeFsType(flexVolumeFsType?.applyValue({ args0 -> args0 }))
            .flexVolumeOptions(flexVolumeOptions?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nfsVolumePath(nfsVolumePath?.applyValue({ args0 -> args0 }))
            .nfsVolumeReadOnly(nfsVolumeReadOnly?.applyValue({ args0 -> args0 }))
            .nfsVolumeServer(nfsVolumeServer?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupVolumeArgs].
 */
@PulumiTagMarker
public class ContainerGroupVolumeArgsBuilder internal constructor() {
    private var configFileVolumeConfigFileToPaths:
        Output<List<ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs>>? = null

    private var diskVolumeDiskId: Output<String>? = null

    private var diskVolumeFsType: Output<String>? = null

    private var flexVolumeDriver: Output<String>? = null

    private var flexVolumeFsType: Output<String>? = null

    private var flexVolumeOptions: Output<String>? = null

    private var name: Output<String>? = null

    private var nfsVolumePath: Output<String>? = null

    private var nfsVolumeReadOnly: Output<Boolean>? = null

    private var nfsVolumeServer: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
     * > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
     */
    @JvmName("iaymlmjyyxpmldtr")
    public suspend fun configFileVolumeConfigFileToPaths(`value`: Output<List<ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs>>) {
        this.configFileVolumeConfigFileToPaths = value
    }

    @JvmName("ipbfqwqcbqmmaall")
    public suspend fun configFileVolumeConfigFileToPaths(vararg values: Output<ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs>) {
        this.configFileVolumeConfigFileToPaths = Output.all(values.asList())
    }

    /**
     * @param values The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
     * > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
     */
    @JvmName("hxohiikrineueckw")
    public suspend fun configFileVolumeConfigFileToPaths(values: List<Output<ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs>>) {
        this.configFileVolumeConfigFileToPaths = Output.all(values)
    }

    /**
     * @param value The ID of DiskVolume.
     */
    @JvmName("yeuscuwmwqswmlqm")
    public suspend fun diskVolumeDiskId(`value`: Output<String>) {
        this.diskVolumeDiskId = value
    }

    /**
     * @param value The system type of DiskVolume.
     */
    @JvmName("hqokxwrfulgbkcxn")
    public suspend fun diskVolumeFsType(`value`: Output<String>) {
        this.diskVolumeFsType = value
    }

    /**
     * @param value The name of the FlexVolume driver.
     */
    @JvmName("dpeqciuxptsjkork")
    public suspend fun flexVolumeDriver(`value`: Output<String>) {
        this.flexVolumeDriver = value
    }

    /**
     * @param value The type of the mounted file system. The default value is determined by the script of FlexVolume.
     */
    @JvmName("wvaknwudcvsbnwsc")
    public suspend fun flexVolumeFsType(`value`: Output<String>) {
        this.flexVolumeFsType = value
    }

    /**
     * @param value The list of FlexVolume objects. Each object is a key-value pair contained in a JSON string.
     */
    @JvmName("upfgimshemxhnrff")
    public suspend fun flexVolumeOptions(`value`: Output<String>) {
        this.flexVolumeOptions = value
    }

    /**
     * @param value The name of the volume.
     */
    @JvmName("lawwnylmvkpibnbr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The path to the NFS volume.
     */
    @JvmName("ejvaeyucwdtpodnp")
    public suspend fun nfsVolumePath(`value`: Output<String>) {
        this.nfsVolumePath = value
    }

    /**
     * @param value The nfs volume read only. Default value: `false`.
     */
    @JvmName("iqvyfflenkyovtjb")
    public suspend fun nfsVolumeReadOnly(`value`: Output<Boolean>) {
        this.nfsVolumeReadOnly = value
    }

    /**
     * @param value The address of the NFS server.
     */
    @JvmName("gkjwsridoeyspobq")
    public suspend fun nfsVolumeServer(`value`: Output<String>) {
        this.nfsVolumeServer = value
    }

    /**
     * @param value The type of the volume.
     */
    @JvmName("hwxgpgpfkmymtuey")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
     * > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
     */
    @JvmName("fwmlkxwgylnywdyy")
    public suspend fun configFileVolumeConfigFileToPaths(`value`: List<ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param argument The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
     * > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
     */
    @JvmName("ftjlalchpjavuchy")
    public suspend fun configFileVolumeConfigFileToPaths(argument: List<suspend ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param argument The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
     * > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
     */
    @JvmName("virtblrohekjegxp")
    public suspend fun configFileVolumeConfigFileToPaths(vararg argument: suspend ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param argument The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
     * > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
     */
    @JvmName("qokscmanwnckugom")
    public suspend fun configFileVolumeConfigFileToPaths(argument: suspend ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param values The paths of the ConfigFile volume. See `config_file_volume_config_file_to_paths` below.
     * > **NOTE:** Every volumes mounted must have `name` and `type` attributes.
     */
    @JvmName("ojysrkkjgbhjqvlp")
    public suspend fun configFileVolumeConfigFileToPaths(vararg values: ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configFileVolumeConfigFileToPaths = mapped
    }

    /**
     * @param value The ID of DiskVolume.
     */
    @JvmName("srttkjfswphkeeld")
    public suspend fun diskVolumeDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskVolumeDiskId = mapped
    }

    /**
     * @param value The system type of DiskVolume.
     */
    @JvmName("efqfbyaylegyscsk")
    public suspend fun diskVolumeFsType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskVolumeFsType = mapped
    }

    /**
     * @param value The name of the FlexVolume driver.
     */
    @JvmName("ysxggvfyxaiownge")
    public suspend fun flexVolumeDriver(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flexVolumeDriver = mapped
    }

    /**
     * @param value The type of the mounted file system. The default value is determined by the script of FlexVolume.
     */
    @JvmName("kymweakrsvxaigll")
    public suspend fun flexVolumeFsType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flexVolumeFsType = mapped
    }

    /**
     * @param value The list of FlexVolume objects. Each object is a key-value pair contained in a JSON string.
     */
    @JvmName("nwjscgyeipnfwvqn")
    public suspend fun flexVolumeOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flexVolumeOptions = mapped
    }

    /**
     * @param value The name of the volume.
     */
    @JvmName("weemoeccsbpwpswu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The path to the NFS volume.
     */
    @JvmName("xbplbyhefsjpafny")
    public suspend fun nfsVolumePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsVolumePath = mapped
    }

    /**
     * @param value The nfs volume read only. Default value: `false`.
     */
    @JvmName("sktrguguxmjppqdg")
    public suspend fun nfsVolumeReadOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsVolumeReadOnly = mapped
    }

    /**
     * @param value The address of the NFS server.
     */
    @JvmName("rgvoyommijviamrw")
    public suspend fun nfsVolumeServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsVolumeServer = mapped
    }

    /**
     * @param value The type of the volume.
     */
    @JvmName("ugsjkxvstyflbxxe")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContainerGroupVolumeArgs = ContainerGroupVolumeArgs(
        configFileVolumeConfigFileToPaths = configFileVolumeConfigFileToPaths,
        diskVolumeDiskId = diskVolumeDiskId,
        diskVolumeFsType = diskVolumeFsType,
        flexVolumeDriver = flexVolumeDriver,
        flexVolumeFsType = flexVolumeFsType,
        flexVolumeOptions = flexVolumeOptions,
        name = name,
        nfsVolumePath = nfsVolumePath,
        nfsVolumeReadOnly = nfsVolumeReadOnly,
        nfsVolumeServer = nfsVolumeServer,
        type = type,
    )
}
