@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The content of the configuration file. Maximum size: 32 KB.
 * @property path
 */
public data class ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs(
    public val content: Output<String>? = null,
    public val path: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs =
        com.pulumi.alicloud.eci.inputs.ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs].
 */
@PulumiTagMarker
public class ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value The content of the configuration file. Maximum size: 32 KB.
     */
    @JvmName("vwmtwihvpadnuvue")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value
     */
    @JvmName("hfivyugjqaloxcpp")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The content of the configuration file. Maximum size: 32 KB.
     */
    @JvmName("hyjqjeincchmfgvy")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value
     */
    @JvmName("amuehegytoreimir")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs =
        ContainerGroupVolumeConfigFileVolumeConfigFileToPathArgs(
            content = content,
            path = path,
        )
}
