@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.GetContainerGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getContainerGroups.
 * @property containerGroupName The name of ContainerGroup.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Container Group IDs.
 * @property limit The maximum number of resources returned in the response. Default value is `20`. Maximum value: `20`. The number of returned results is no greater than the specified number.
 * @property nameRegex A regex string to filter results by Container Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group to which the container group belongs. If you have not specified a resource group for the container group, it is added to the default resource group.
 * @property status The status list. For more information, see the description of ContainerGroup arrays.
 * @property tags
 * @property vswitchId The ID of the vSwitch. Currently, container groups can only be deployed in VPC networks.
 * @property withEvent
 * @property zoneId The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
 */
public data class GetContainerGroupsPlainArgs(
    public val containerGroupName: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val limit: Int? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vswitchId: String? = null,
    public val withEvent: Boolean? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.GetContainerGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.GetContainerGroupsPlainArgs =
        com.pulumi.alicloud.eci.inputs.GetContainerGroupsPlainArgs.builder()
            .containerGroupName(containerGroupName?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .limit(limit?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.let({ args0 -> args0 }))
            .withEvent(withEvent?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetContainerGroupsPlainArgsBuilder internal constructor() {
    private var containerGroupName: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var limit: Int? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var vswitchId: String? = null

    private var withEvent: Boolean? = null

    private var zoneId: String? = null

    /**
     * @param value The name of ContainerGroup.
     */
    @JvmName("yuwoqdndyrhompue")
    public suspend fun containerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.containerGroupName = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("qmtchobxlnvqjpch")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Container Group IDs.
     */
    @JvmName("jhmrucpskekadabm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Container Group IDs.
     */
    @JvmName("xjjqkvufvppicxme")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The maximum number of resources returned in the response. Default value is `20`. Maximum value: `20`. The number of returned results is no greater than the specified number.
     */
    @JvmName("xertetjqdndqnaha")
    public suspend fun limit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.limit = mapped
    }

    /**
     * @param value A regex string to filter results by Container Group name.
     */
    @JvmName("bwllxobrerkyfthh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yyfgrobfvopiraiv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group to which the container group belongs. If you have not specified a resource group for the container group, it is added to the default resource group.
     */
    @JvmName("fyijweacylovpvxn")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status list. For more information, see the description of ContainerGroup arrays.
     */
    @JvmName("dieeirvnhiqshhji")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("blxmncvhxiirrfay")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("dnvhfdrrpetfmqsw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The ID of the vSwitch. Currently, container groups can only be deployed in VPC networks.
     */
    @JvmName("irkllmdexdyhkuax")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    /**
     * @param value
     */
    @JvmName("hghrhqcuvieuqjol")
    public suspend fun withEvent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withEvent = mapped
    }

    /**
     * @param value The ID of the zone where you want to deploy the container group. If no value is specified, the system assigns a zone to the container group. By default, no value is specified.
     */
    @JvmName("sjhghhcgaeephmuq")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetContainerGroupsPlainArgs = GetContainerGroupsPlainArgs(
        containerGroupName = containerGroupName,
        enableDetails = enableDetails,
        ids = ids,
        limit = limit,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
        tags = tags,
        vswitchId = vswitchId,
        withEvent = withEvent,
        zoneId = zoneId,
    )
}
