@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.GetImageCachesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImageCaches.
 * @property ids A list ids of ECI Image Cache.
 * @property image Find the mirror cache containing it according to the image name.
 * @property imageCacheName The name of ECI Image Cache.
 * @property nameRegex A regex string to filter results by the image cache name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property snapshotId The id of snapshot.
 * @property status The status of ECI Image Cache.
 */
public data class GetImageCachesPlainArgs(
    public val ids: List<String>? = null,
    public val image: String? = null,
    public val imageCacheName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val snapshotId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.GetImageCachesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.GetImageCachesPlainArgs =
        com.pulumi.alicloud.eci.inputs.GetImageCachesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .image(image?.let({ args0 -> args0 }))
            .imageCacheName(imageCacheName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .snapshotId(snapshotId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImageCachesPlainArgs].
 */
@PulumiTagMarker
public class GetImageCachesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var image: String? = null

    private var imageCacheName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var snapshotId: String? = null

    private var status: String? = null

    /**
     * @param value A list ids of ECI Image Cache.
     */
    @JvmName("ddhxvfwkubcrmwxn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list ids of ECI Image Cache.
     */
    @JvmName("flyylowfcwuxrsgk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Find the mirror cache containing it according to the image name.
     */
    @JvmName("bqjxbpdjeqctjyyc")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.image = mapped
    }

    /**
     * @param value The name of ECI Image Cache.
     */
    @JvmName("icydrynewmmjpcjs")
    public suspend fun imageCacheName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageCacheName = mapped
    }

    /**
     * @param value A regex string to filter results by the image cache name.
     */
    @JvmName("mxjlfpqfgnqcqqjf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pyiebvyfkqlemqfw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The id of snapshot.
     */
    @JvmName("uwijxcuxeidmqvhf")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotId = mapped
    }

    /**
     * @param value The status of ECI Image Cache.
     */
    @JvmName("jbeypiukmjplxqhi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetImageCachesPlainArgs = GetImageCachesPlainArgs(
        ids = ids,
        image = image,
        imageCacheName = imageCacheName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        snapshotId = snapshotId,
        status = status,
    )
}
