@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.GetVirtualNodesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVirtualNodes.
 * @property ids A list of Virtual Node IDs.
 * @property nameRegex A regex string to filter results by Virtual Node name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The resource group ID. If when you create a GPU does not specify a resource group instance will automatically add the account's default resource group.
 * @property securityGroupId VNode itself and by VNode created (ECI) the security group used by.
 * @property status The Status of the virtual node. Valid values: `Cleaned`, `Failed`, `Pending`, `Ready`.
 * @property tags A mapping of tags to assign to the resource.
 * @property virtualNodeName The name of the virtual node.
 * @property vswitchId
 */
public data class GetVirtualNodesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val securityGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val virtualNodeName: String? = null,
    public val vswitchId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.GetVirtualNodesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.GetVirtualNodesPlainArgs =
        com.pulumi.alicloud.eci.inputs.GetVirtualNodesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNodeName(virtualNodeName?.let({ args0 -> args0 }))
            .vswitchId(vswitchId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNodesPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNodesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var securityGroupId: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var virtualNodeName: String? = null

    private var vswitchId: String? = null

    /**
     * @param value A list of Virtual Node IDs.
     */
    @JvmName("rexulxpwrsyttweh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Virtual Node IDs.
     */
    @JvmName("dsnotyyrhfnjmcrp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Virtual Node name.
     */
    @JvmName("ryumpginvxvrbvfn")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wduxbsfomxmypwwq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The resource group ID. If when you create a GPU does not specify a resource group instance will automatically add the account's default resource group.
     */
    @JvmName("xolrlpbxxhxjxrpj")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value VNode itself and by VNode created (ECI) the security group used by.
     */
    @JvmName("yayhkfkmmdmqtrtl")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityGroupId = mapped
    }

    /**
     * @param value The Status of the virtual node. Valid values: `Cleaned`, `Failed`, `Pending`, `Ready`.
     */
    @JvmName("siyfuqikpebkmkrd")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("iowwxwmmqxqyiphr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("njucekexuoldbgmi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The name of the virtual node.
     */
    @JvmName("jlefdobfermwlpei")
    public suspend fun virtualNodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.virtualNodeName = mapped
    }

    /**
     * @param value
     */
    @JvmName("fdwmjwmlfnypmudj")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    internal fun build(): GetVirtualNodesPlainArgs = GetVirtualNodesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        securityGroupId = securityGroupId,
        status = status,
        tags = tags,
        virtualNodeName = virtualNodeName,
        vswitchId = vswitchId,
    )
}
