@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.ImageCacheImageRegistryCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password The password of the Image Registry.
 * @property server The address of Image Registry without `http://` or `https://`.
 * @property userName The user name of Image Registry.
 */
public data class ImageCacheImageRegistryCredentialArgs(
    public val password: Output<String>? = null,
    public val server: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.ImageCacheImageRegistryCredentialArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.ImageCacheImageRegistryCredentialArgs =
        com.pulumi.alicloud.eci.inputs.ImageCacheImageRegistryCredentialArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageCacheImageRegistryCredentialArgs].
 */
@PulumiTagMarker
public class ImageCacheImageRegistryCredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var server: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The password of the Image Registry.
     */
    @JvmName("kvwiwgyqvcuemjmo")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The address of Image Registry without `http://` or `https://`.
     */
    @JvmName("nikeeylirdduupne")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The user name of Image Registry.
     */
    @JvmName("tgmnuoddxhexjgmc")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The password of the Image Registry.
     */
    @JvmName("fdbxjvmldenaqjly")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The address of Image Registry without `http://` or `https://`.
     */
    @JvmName("xdhpplguiyhcupgf")
    public suspend fun server(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The user name of Image Registry.
     */
    @JvmName("nxqlobkwfxgagcet")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): ImageCacheImageRegistryCredentialArgs =
        ImageCacheImageRegistryCredentialArgs(
            password = password,
            server = server,
            userName = userName,
        )
}
