@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.OpenApiImageCacheImageRegistryCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password
 * @property server
 * @property userName
 */
public data class OpenApiImageCacheImageRegistryCredentialArgs(
    public val password: Output<String>? = null,
    public val server: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.OpenApiImageCacheImageRegistryCredentialArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.OpenApiImageCacheImageRegistryCredentialArgs = com.pulumi.alicloud.eci.inputs.OpenApiImageCacheImageRegistryCredentialArgs.builder()
        .password(password?.applyValue({ args0 -> args0 }))
        .server(server?.applyValue({ args0 -> args0 }))
        .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenApiImageCacheImageRegistryCredentialArgs].
 */
@PulumiTagMarker
public class OpenApiImageCacheImageRegistryCredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var server: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qydkttviyofdmnip")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value
     */
    @JvmName("npfbawrteakdjosn")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value
     */
    @JvmName("edfalsibeagxphxy")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value
     */
    @JvmName("uvpowsrovafeinjg")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value
     */
    @JvmName("lwysgdpavpjstprx")
    public suspend fun server(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value
     */
    @JvmName("bwvkarflmywtcyos")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): OpenApiImageCacheImageRegistryCredentialArgs =
        OpenApiImageCacheImageRegistryCredentialArgs(
            password = password,
            server = server,
            userName = userName,
        )
}
