@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.inputs

import com.pulumi.alicloud.eci.inputs.VirtualNodeTaintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property effect The effect of the taint. Valid values: `NoSchedule`, `NoExecute` and `PreferNoSchedule`.
 * @property key The key of the taint.
 * @property value The value of the taint.
 */
public data class VirtualNodeTaintArgs(
    public val effect: Output<String>? = null,
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.eci.inputs.VirtualNodeTaintArgs> {
    override fun toJava(): com.pulumi.alicloud.eci.inputs.VirtualNodeTaintArgs =
        com.pulumi.alicloud.eci.inputs.VirtualNodeTaintArgs.builder()
            .effect(effect?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNodeTaintArgs].
 */
@PulumiTagMarker
public class VirtualNodeTaintArgsBuilder internal constructor() {
    private var effect: Output<String>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The effect of the taint. Valid values: `NoSchedule`, `NoExecute` and `PreferNoSchedule`.
     */
    @JvmName("yaymrmumdyfsthqv")
    public suspend fun effect(`value`: Output<String>) {
        this.effect = value
    }

    /**
     * @param value The key of the taint.
     */
    @JvmName("boybgwrufhgelbkf")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value of the taint.
     */
    @JvmName("udwtgufjdyxpcbps")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The effect of the taint. Valid values: `NoSchedule`, `NoExecute` and `PreferNoSchedule`.
     */
    @JvmName("fukarvvytrqgolkm")
    public suspend fun effect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effect = mapped
    }

    /**
     * @param value The key of the taint.
     */
    @JvmName("wfdsjubcihuywbxe")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value of the taint.
     */
    @JvmName("fxpvyuvwurqepckr")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): VirtualNodeTaintArgs = VirtualNodeTaintArgs(
        effect = effect,
        key = key,
        `value` = `value`,
    )
}
