@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property domains The domain name of the ACR Enterprise Edition instance. Defaults to all domain names of the corresponding instance. Support specifying individual domain names, multiple separated by half comma.
 * @property instanceId The ACR enterprise edition example ID.
 * @property instanceName The name of the ACR enterprise edition instance.
 * @property regionId The ACR enterprise edition instance belongs to the region.
 */
public data class ContainerGroupAcrRegistryInfo(
    public val domains: List<String>? = null,
    public val instanceId: String? = null,
    public val instanceName: String? = null,
    public val regionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.ContainerGroupAcrRegistryInfo): ContainerGroupAcrRegistryInfo = ContainerGroupAcrRegistryInfo(
            domains = javaType.domains().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            instanceName = javaType.instanceName().map({ args0 -> args0 }).orElse(null),
            regionId = javaType.regionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
