@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property args The arguments passed to the commands.
 * @property commands Commands to be executed inside the container when performing health checks using the command line method.
 * @property cpu The amount of CPU resources allocated to the container. Default value: `0`.
 * @property environmentVars The structure of environmentVars. See `environment_vars` below.
 * @property gpu The number GPUs. Default value: `0`.
 * @property image The image of the container.
 * @property imagePullPolicy The restart policy of the image. Default value: `IfNotPresent`. Valid values: `Always`, `IfNotPresent`, `Never`.
 * @property lifecyclePreStopHandlerExecs The commands to be executed in containers when you use the CLI to specify the preStop callback function.
 * @property livenessProbes The health check of the container. See `liveness_probe` below.
 * @property memory The amount of memory resources allocated to the container. Default value: `0`.
 * @property name The name of the mounted volume.
 * @property ports The structure of port. See `ports` below.
 * @property readinessProbes The health check of the container. See `readiness_probe` below.
 * @property ready Indicates whether the container passed the readiness probe.
 * @property restartCount The number of times that the container restarted.
 * @property securityContexts The security context of the container. See `security_context` below.
 * @property volumeMounts The structure of volumeMounts. See `volume_mounts` below.
 * @property workingDir The working directory of the container.
 */
public data class ContainerGroupContainer(
    public val args: List<String>? = null,
    public val commands: List<String>? = null,
    public val cpu: Double? = null,
    public val environmentVars: List<ContainerGroupContainerEnvironmentVar>? = null,
    public val gpu: Int? = null,
    public val image: String,
    public val imagePullPolicy: String? = null,
    public val lifecyclePreStopHandlerExecs: List<String>? = null,
    public val livenessProbes: List<ContainerGroupContainerLivenessProbe>? = null,
    public val memory: Double? = null,
    public val name: String,
    public val ports: List<ContainerGroupContainerPort>? = null,
    public val readinessProbes: List<ContainerGroupContainerReadinessProbe>? = null,
    public val ready: Boolean? = null,
    public val restartCount: Int? = null,
    public val securityContexts: List<ContainerGroupContainerSecurityContext>? = null,
    public val volumeMounts: List<ContainerGroupContainerVolumeMount>? = null,
    public val workingDir: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.ContainerGroupContainer): ContainerGroupContainer = ContainerGroupContainer(
            args = javaType.args().map({ args0 -> args0 }),
            commands = javaType.commands().map({ args0 -> args0 }),
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            environmentVars = javaType.environmentVars().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerEnvironmentVar.Companion.toKotlin(args0)
                })
            }),
            gpu = javaType.gpu().map({ args0 -> args0 }).orElse(null),
            image = javaType.image(),
            imagePullPolicy = javaType.imagePullPolicy().map({ args0 -> args0 }).orElse(null),
            lifecyclePreStopHandlerExecs = javaType.lifecyclePreStopHandlerExecs().map({ args0 -> args0 }),
            livenessProbes = javaType.livenessProbes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerLivenessProbe.Companion.toKotlin(args0)
                })
            }),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            ports = javaType.ports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerPort.Companion.toKotlin(args0)
                })
            }),
            readinessProbes = javaType.readinessProbes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerReadinessProbe.Companion.toKotlin(args0)
                })
            }),
            ready = javaType.ready().map({ args0 -> args0 }).orElse(null),
            restartCount = javaType.restartCount().map({ args0 -> args0 }).orElse(null),
            securityContexts = javaType.securityContexts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerSecurityContext.Companion.toKotlin(args0)
                })
            }),
            volumeMounts = javaType.volumeMounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerVolumeMount.Companion.toKotlin(args0)
                })
            }),
            workingDir = javaType.workingDir().map({ args0 -> args0 }).orElse(null),
        )
    }
}
