@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property execs Health check using command line method. See `exec` below.
 * @property failureThreshold Threshold for the number of checks that are determined to have failed since the last successful check (must be consecutive failures), default is 3.
 * @property httpGets Health check using HTTP request method. See `http_get` below.
 * > **NOTE:** When you configure `readiness_probe`, you can select only one of the `exec`, `tcp_socket`, `http_get`.
 * @property initialDelaySeconds Check the time to start execution, calculated from the completion of container startup.
 * @property periodSeconds Buffer time for the program to handle operations before closing.
 * @property successThreshold The check count threshold for re-identifying successful checks since the last failed check (must be consecutive successes), default is 1. Current must be 1.
 * @property tcpSockets Health check using TCP socket method. See `tcp_socket` below.
 * @property timeoutSeconds Check the timeout, the default is 1 second, the minimum is 1 second.
 */
public data class ContainerGroupContainerReadinessProbe(
    public val execs: List<ContainerGroupContainerReadinessProbeExec>? = null,
    public val failureThreshold: Int? = null,
    public val httpGets: List<ContainerGroupContainerReadinessProbeHttpGet>? = null,
    public val initialDelaySeconds: Int? = null,
    public val periodSeconds: Int? = null,
    public val successThreshold: Int? = null,
    public val tcpSockets: List<ContainerGroupContainerReadinessProbeTcpSocket>? = null,
    public val timeoutSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.ContainerGroupContainerReadinessProbe): ContainerGroupContainerReadinessProbe = ContainerGroupContainerReadinessProbe(
            execs = javaType.execs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerReadinessProbeExec.Companion.toKotlin(args0)
                })
            }),
            failureThreshold = javaType.failureThreshold().map({ args0 -> args0 }).orElse(null),
            httpGets = javaType.httpGets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerReadinessProbeHttpGet.Companion.toKotlin(args0)
                })
            }),
            initialDelaySeconds = javaType.initialDelaySeconds().map({ args0 -> args0 }).orElse(null),
            periodSeconds = javaType.periodSeconds().map({ args0 -> args0 }).orElse(null),
            successThreshold = javaType.successThreshold().map({ args0 -> args0 }).orElse(null),
            tcpSockets = javaType.tcpSockets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerReadinessProbeTcpSocket.Companion.toKotlin(args0)
                })
            }),
            timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
