@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.eci.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property capabilities
 * @property privileged Specifies whether to give extended privileges to this container. Default value: `false`. Valid values: `true` and `false`.
 * @property runAsUser
 */
public data class ContainerGroupContainerSecurityContext(
    public val capabilities: List<ContainerGroupContainerSecurityContextCapability>? = null,
    public val privileged: Boolean? = null,
    public val runAsUser: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.eci.outputs.ContainerGroupContainerSecurityContext): ContainerGroupContainerSecurityContext = ContainerGroupContainerSecurityContext(
            capabilities = javaType.capabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.eci.kotlin.outputs.ContainerGroupContainerSecurityContextCapability.Companion.toKotlin(args0)
                })
            }),
            privileged = javaType.privileged().map({ args0 -> args0 }).orElse(null),
            runAsUser = javaType.runAsUser().map({ args0 -> args0 }).orElse(null),
        )
    }
}
